/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.packet;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import org.embeddedt.modernfix.ModernFix;

public class EntityIDSyncPacket {
    private Map<Class<? extends Entity>, List<Pair<String, Integer>>> map;

    public EntityIDSyncPacket(Map<Class<? extends Entity>, List<Pair<String, Integer>>> map) {
        this.map = map;
    }

    public Map<Class<? extends Entity>, List<Pair<String, Integer>>> getFieldInfo() {
        return this.map;
    }

    public EntityIDSyncPacket() {
        this.map = new HashMap<Class<? extends Entity>, List<Pair<String, Integer>>>();
    }

    public void serialize(PacketBuffer buf) {
        buf.func_150787_b(this.map.keySet().size());
        for (Map.Entry<Class<? extends Entity>, List<Pair<String, Integer>>> entry : this.map.entrySet()) {
            buf.func_180714_a(entry.getKey().getName());
            buf.func_150787_b(entry.getValue().size());
            for (Pair<String, Integer> field : entry.getValue()) {
                buf.func_180714_a((String)field.getFirst());
                buf.func_150787_b(((Integer)field.getSecond()).intValue());
            }
        }
    }

    public static EntityIDSyncPacket deserialize(PacketBuffer buf) {
        EntityIDSyncPacket self = new EntityIDSyncPacket();
        int numEntityClasses = buf.func_150792_a();
        for (int i = 0; i < numEntityClasses; ++i) {
            String clzName = buf.func_218666_n();
            try {
                Class<?> clz;
                try {
                    clz = Class.forName(clzName);
                }
                catch (ClassNotFoundException e) {
                    ModernFix.LOGGER.warn("Entity class not found: {}", (Object)clzName);
                    break;
                }
                if (!Entity.class.isAssignableFrom(clz)) {
                    ModernFix.LOGGER.error("Not an entity: " + clzName);
                    break;
                }
                int numFields = buf.func_150792_a();
                for (int j = 0; j < numFields; ++j) {
                    String fieldName = buf.func_218666_n();
                    int id = buf.func_150792_a();
                    Field f = clz.getDeclaredField(fieldName);
                    if (!Modifier.isStatic(f.getModifiers())) continue;
                    f.setAccessible(true);
                    if (!DataParameter.class.isAssignableFrom(f.get(null).getClass())) {
                        ModernFix.LOGGER.error("Not a data accessor field: " + clz + "." + fieldName);
                        continue;
                    }
                    self.map.computeIfAbsent(clz, k -> new ArrayList()).add(Pair.of((Object)fieldName, (Object)id));
                }
                continue;
            }
            catch (ReflectiveOperationException e) {
                ModernFix.LOGGER.error("Error deserializing packet", (Throwable)e);
            }
        }
        return self;
    }
}

