/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.structure.logic;

import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import org.embeddedt.modernfix.forge.mixin.perf.async_locator.MapItemAccess;

public class CommonLogic {
    private static final String MAP_HOVER_NAME_KEY = "menu.working";
    private static final String KEY_LOCATING = "asynclocator.locating";

    private CommonLogic() {
    }

    public static ItemStack createEmptyMap() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151098_aY);
        stack.func_200302_a((ITextComponent)new TranslationTextComponent(MAP_HOVER_NAME_KEY));
        stack.func_77983_a(KEY_LOCATING, (INBT)ByteNBT.field_229670_c_);
        return stack;
    }

    public static boolean isEmptyPendingMap(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151098_aY && stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_LOCATING);
    }

    public static void updateMap(ItemStack mapStack, ServerWorld level, BlockPos pos, int scale, MapDecoration.Type destinationType) {
        CommonLogic.updateMap(mapStack, level, pos, scale, destinationType, (ITextComponent)null);
    }

    public static void updateMap(ItemStack mapStack, ServerWorld level, BlockPos pos, int scale, MapDecoration.Type destinationType, String displayName) {
        CommonLogic.updateMap(mapStack, level, pos, scale, destinationType, (ITextComponent)new TranslationTextComponent(displayName));
    }

    public static void updateMap(ItemStack mapStack, ServerWorld level, BlockPos pos, int scale, MapDecoration.Type destinationType, ITextComponent displayName) {
        MapItemAccess.callCreateAndStoreSavedData(mapStack, (World)level, pos.func_177958_n(), pos.func_177952_p(), scale, true, true, (RegistryKey<World>)level.func_234923_W_());
        FilledMapItem.func_226642_a_((ServerWorld)level, (ItemStack)mapStack);
        MapData.func_191094_a((ItemStack)mapStack, (BlockPos)pos, (String)"+", (MapDecoration.Type)destinationType);
        if (displayName != null) {
            mapStack.func_200302_a(displayName);
        }
        mapStack.func_196083_e(KEY_LOCATING);
    }

    public static void broadcastChestChanges(ServerWorld level, TileEntity be) {
        if (!(be instanceof ChestTileEntity)) {
            return;
        }
        level.func_217369_A().forEach(player -> {
            Container container = player.field_71070_bA;
            if (container instanceof ChestContainer && ((ChestContainer)container).func_85151_d() == be) {
                container.func_75142_b();
            }
        });
    }
}

