/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.structure;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.embeddedt.modernfix.ModernFix;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="modernfix")
public class AsyncLocator {
    private static ExecutorService LOCATING_EXECUTOR_SERVICE = null;
    private static final AtomicInteger poolNum = new AtomicInteger(1);

    private AsyncLocator() {
    }

    private static void setupExecutorService() {
        AsyncLocator.shutdownExecutorService();
        int threads = 1;
        ModernFix.LOGGER.info("Starting locating executor service with thread pool size of {}", (Object)threads);
        LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(threads, new ThreadFactory(){
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "asynclocator-" + AsyncLocator.access$000().getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread((ThreadGroup)SidedThreadGroups.SERVER, r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    private static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            ModernFix.LOGGER.info("Shutting down locating executor service");
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent ignoredEvent) {
        AsyncLocator.setupExecutorService();
    }

    @SubscribeEvent
    public static void handleServerStoppingEvent(FMLServerStoppingEvent ignoredEvent) {
        AsyncLocator.shutdownExecutorService();
    }

    public static LocateTask<BlockPos> locateLevel(ServerWorld level, Collection<Structure<?>> structure, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        ModernFix.LOGGER.debug("Creating locate task for {} in {} around {} within {} chunks", structure, (Object)level, (Object)pos, (Object)searchRadius);
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateLevel(completableFuture, level, structure, pos, searchRadius, skipKnownStructures));
        return new LocateTask<BlockPos>(level.func_73046_m(), completableFuture, future);
    }

    public static LocateTask<Pair<BlockPos, Structure<?>>> locateChunkGen(ServerWorld level, Collection<Structure<?>> structureSet, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        ModernFix.LOGGER.debug("Creating locate task for {} in {} around {} within {} chunks", structureSet, (Object)level, (Object)pos, (Object)searchRadius);
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateChunkGenerator(completableFuture, level, structureSet, pos, searchRadius, skipKnownStructures));
        return new LocateTask(level.func_73046_m(), completableFuture, future);
    }

    private static String structureSetToString(Collection<Structure<?>> collection) {
        return "[" + collection.stream().map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).collect(Collectors.joining(", ")) + "]";
    }

    private static void doLocateLevel(CompletableFuture<BlockPos> completableFuture, ServerWorld level, Collection<Structure<?>> structureTag, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        String structures = AsyncLocator.structureSetToString(structureTag);
        ModernFix.LOGGER.debug("Trying to locate {} in {} around {} within {} chunks", (Object)structures, (Object)level, (Object)pos, (Object)searchRadius);
        Optional<BlockPos> thePosition = structureTag.stream().map(tag -> level.func_241117_a_(tag, pos, searchRadius, skipExistingChunks)).filter(Objects::nonNull).findFirst();
        if (!thePosition.isPresent()) {
            ModernFix.LOGGER.debug("No {} found", (Object)structures);
        } else {
            ModernFix.LOGGER.debug("Found {} at {}", (Object)structures, (Object)thePosition.get());
        }
        completableFuture.complete(thePosition.orElse(null));
    }

    private static void doLocateChunkGenerator(CompletableFuture<Pair<BlockPos, Structure<?>>> completableFuture, ServerWorld level, Collection<Structure<?>> structureSet, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        String structures = AsyncLocator.structureSetToString(structureSet);
        ModernFix.LOGGER.debug("Trying to locate {} in {} around {} within {} chunks", (Object)structures, (Object)level, (Object)pos, (Object)searchRadius);
        Optional<Pair> foundStructure = structureSet.stream().map(feature -> Pair.of((Object)level.func_72863_F().func_201711_g().func_235956_a_(level, feature, pos, searchRadius, skipExistingChunks), (Object)feature)).filter(pair -> pair.getFirst() != null).findFirst();
        if (!foundStructure.isPresent()) {
            ModernFix.LOGGER.debug("No {} found", (Object)structures);
        } else {
            ModernFix.LOGGER.debug("Found {} at {}", (Object)structures, foundStructure.get().getFirst());
        }
        completableFuture.complete(foundStructure.orElse(null));
    }

    static /* synthetic */ AtomicInteger access$000() {
        return poolNum;
    }

    public static class LocateTask<T> {
        private final MinecraftServer server;
        private final CompletableFuture<T> completableFuture;
        private final Future<?> taskFuture;

        public LocateTask(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
            this.server = server;
            this.completableFuture = completableFuture;
            this.taskFuture = taskFuture;
        }

        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.func_222817_e(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

