/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.kubejs;

import com.google.gson.JsonObject;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import dev.latvian.kubejs.recipe.RecipeEventJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.recipe.filter.RecipeFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.forge.util.KubeUtil;
import org.embeddedt.modernfix.forge.util.ModUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeEventJS.class})
@RequiresMod(value="kubejs")
public class RecipeEventJSMixin {
    @Shadow(remap=false)
    @Final
    private List<RecipeJS> originalRecipes;

    @Overwrite(remap=false)
    public void forEachRecipe(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.originalRecipes.forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            List filtered = (List)LamdbaExceptionUtils.uncheck(() -> (List)((ForkJoinTask)ModUtil.commonPool.submit(() -> this.originalRecipes.parallelStream().filter(filter).collect(Collectors.toList()))).get());
            filtered.forEach(consumer);
        }
    }

    @Inject(method={"post(Lnet/minecraft/world/item/crafting/RecipeManager;Ljava/util/Map;)V"}, at={@At(value="INVOKE", target="Ldev/latvian/kubejs/recipe/RecipeEventJS;post(Ldev/latvian/kubejs/script/ScriptType;Ljava/lang/String;)Z", remap=false)})
    private void buildRecipeRegistry(RecipeManager manager, Map<ResourceLocation, JsonObject> jsonMap, CallbackInfo ci) {
        for (RecipeJS recipe : this.originalRecipes) {
            KubeUtil.originalRecipesByHash.put(recipe.getOrCreateId(), recipe);
        }
    }

    @Inject(method={"post(Lnet/minecraft/world/item/crafting/RecipeManager;Ljava/util/Map;)V"}, at={@At(value="RETURN")})
    private void clearRecipeRegistry(RecipeManager manager, Map<ResourceLocation, JsonObject> jsonMap, CallbackInfo ci) {
        KubeUtil.originalRecipesByHash.clear();
    }

    @Inject(method={"post"}, at={@At(value="RETURN")})
    private void clearRecipeLists(CallbackInfo ci) {
        Field[] fields;
        ModernFix.LOGGER.info("Clearing KubeJS recipe lists...");
        for (Field f : fields = RecipeEventJS.class.getDeclaredFields()) {
            try {
                int size;
                if (Modifier.isStatic(f.getModifiers()) || !Collection.class.isAssignableFrom(f.getType()) && !Map.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                Object collection = f.get(this);
                if (collection instanceof Map) {
                    size = ((Map)collection).size();
                    ((Map)collection).clear();
                } else if (collection instanceof Collection) {
                    size = ((Collection)collection).size();
                    ((Collection)collection).clear();
                } else {
                    throw new IllegalStateException();
                }
                ModernFix.LOGGER.debug("Cleared {} with {} entries", (Object)f.getName(), (Object)size);
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                ModernFix.LOGGER.debug("Uh oh, couldn't clear field", (Throwable)e);
            }
        }
    }
}

