/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.classloading;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.ExplodedDirectoryLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.resources.CachedResourcePath;
import org.embeddedt.modernfix.util.FileUtil;

public class ModernFixResourceFinder {
    private static Multimap<CachedResourcePath, String> urlsForClass = null;
    private static final Class<? extends IModLocator> MINECRAFT_LOCATOR;
    private static Field explodedDirModsField;
    private static final Logger LOGGER;

    public static synchronized void init() throws ReflectiveOperationException {
        FileUtil.normalize("");
        ImmutableMultimap.Builder urlBuilder = ImmutableMultimap.builder();
        for (ModFileInfo fileInfo : LoadingModList.get().getModFiles()) {
            ModFile file = fileInfo.getFile();
            IModLocator locator = file.getLocator();
            Iterable<Path> rootPath = ModernFixResourceFinder.getRootPathForLocator(locator, file);
            for (Path root : rootPath) {
                if (!Files.exists(root, new LinkOption[0])) continue;
                try {
                    Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);
                    try {
                        stream.map(root::relativize).forEach(path -> {
                            CachedResourcePath p = new CachedResourcePath(CachedResourcePath.NO_PREFIX, (Path)path);
                            urlBuilder.put((Object)p, (Object)((IModInfo)fileInfo.getMods().get(0)).getModId());
                        });
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        urlsForClass = urlBuilder.build();
    }

    private static Iterable<Path> getRootPathForLocator(IModLocator locator, ModFile file) throws ReflectiveOperationException {
        if (locator instanceof AbstractJarFileLocator) {
            FileSystem modFs = locator.findPath((IModFile)file, new String[]{"."}).getFileSystem();
            return modFs.getRootDirectories();
        }
        if (locator instanceof ExplodedDirectoryLocator) {
            if (explodedDirModsField == null) {
                explodedDirModsField = ExplodedDirectoryLocator.class.getDeclaredField("mods");
                explodedDirModsField.setAccessible(true);
            }
            Map mods = (Map)explodedDirModsField.get(locator);
            return (Iterable)((Pair)mods.get(file)).getRight();
        }
        if (MINECRAFT_LOCATOR.isAssignableFrom(locator.getClass())) {
            Path mcJar = FMLLoader.getMCPaths()[0];
            if (Files.isDirectory(mcJar, new LinkOption[0])) {
                return mcJar;
            }
            return locator.findPath((IModFile)file, new String[]{"."}).getFileSystem().getRootDirectories();
        }
        throw new UnsupportedOperationException("Unknown ModLocator type: " + locator.getClass().getName());
    }

    public static Enumeration<URL> findAllURLsForResource(String input) {
        int endChar;
        int n = endChar = input.length() > 0 ? (int)input.charAt(input.length() - 1) : 47;
        if (endChar == 47 || endChar == 92) {
            return LoadingModList.get().findAllURLsForResource(input);
        }
        Collection urlList = urlsForClass.get((Object)new CachedResourcePath(input));
        if (!urlList.isEmpty()) {
            String pathInput = FileUtil.normalize(input);
            return Iterators.asEnumeration(urlList.stream().map(modId -> {
                try {
                    return new URL("modjar://" + modId + "/" + pathInput);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).iterator());
        }
        return Collections.emptyEnumeration();
    }

    static {
        explodedDirModsField = null;
        LOGGER = LogManager.getLogger((String)"ModernFixResourceFinder");
        try {
            MINECRAFT_LOCATOR = Class.forName("net.minecraftforge.fml.loading.moddiscovery.ModDiscoverer$MinecraftLocator");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

