/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.util.ResourceLocation;

public class DynamicModelProvider {
    private final Map<ResourceLocation, IUnbakedModel> internalModels;
    private final Cache<ResourceLocation, Optional<IUnbakedModel>> loadedModels = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build();

    public DynamicModelProvider(Map<ResourceLocation, IUnbakedModel> initialModels) {
        this.internalModels = initialModels;
    }

    public IUnbakedModel getModel(ResourceLocation location) {
        try {
            return ((Optional)this.loadedModels.get((Object)location, () -> Optional.ofNullable(this.loadModel(location)))).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private IUnbakedModel loadModel(ResourceLocation location) {
        return null;
    }
}

