/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.core;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.core.config.ModernFixEarlyConfig;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.world.ThreadDumper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;

public class ModernFixMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "org.embeddedt.modernfix.mixin.";
    public final Logger logger = LogManager.getLogger((String)"ModernFix");
    public ModernFixEarlyConfig config = null;
    public static ModernFixMixinPlugin instance;

    public ModernFixMixinPlugin() {
        boolean firstConfig;
        ModernFixPlatformHooks.INSTANCE.getCustomModOptions();
        boolean bl = firstConfig = instance == null;
        if (firstConfig) {
            instance = this;
            try {
                this.config = ModernFixEarlyConfig.load(new File("./config/modernfix-mixins.properties"));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load configuration file for ModernFix", e);
            }
            this.logger.info("Loaded configuration file for ModernFix {}: {} options available, {} override(s) found", (Object)ModernFixPlatformHooks.INSTANCE.getVersionString(), (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
            this.config.getOptionMap().values().forEach(option -> {
                if (option.isOverridden()) {
                    String source = "[unknown]";
                    if (option.isUserDefined()) {
                        source = "user configuration";
                    } else if (!ModernFixPlatformHooks.INSTANCE.isEarlyLoadingNormally()) {
                        source = "load error";
                    } else if (option.isModDefined()) {
                        source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
                    }
                    this.logger.warn("Option '{}' overriden (by {}) to '{}'", (Object)option.getName(), (Object)source, (Object)option.isEnabled());
                }
            });
            if (ModernFixEarlyConfig.OPTIFINE_PRESENT) {
                this.logger.fatal("OptiFine detected. Use of ModernFix with OptiFine is not supported due to its impact on launch time and breakage of Forge features.");
            }
            try {
                Class.forName("sun.misc.Unsafe").getDeclaredMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
            }
            catch (NullPointerException | ReflectiveOperationException e) {
                this.logger.info("Applying Nashorn fix");
                Properties properties = System.getProperties();
                properties.setProperty("nashorn.args", properties.getProperty("nashorn.args", "") + " --anonymous-classes=false");
            }
            ModernFixPlatformHooks.INSTANCE.injectPlatformSpecificHacks();
            if (instance.isOptionEnabled("feature.spam_thread_dump.ThreadDumper")) {
                ThreadDumper.obtainThreadDump();
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(60000L);
                                    ModernFixMixinPlugin.this.logger.error("------ DEBUG THREAD DUMP (occurs every 60 seconds) ------");
                                    ModernFixMixinPlugin.this.logger.error(ThreadDumper.obtainThreadDump());
                                }
                            }
                            catch (InterruptedException | RuntimeException exception) {
                                continue;
                            }
                            break;
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!(mixinClassName = ModernFixEarlyConfig.sanitize(mixinClassName)).startsWith(MIXIN_PACKAGE_ROOT)) {
            this.logger.error("Expected mixin '{}' to start with package root '{}', treating as foreign and disabling!", (Object)mixinClassName, (Object)MIXIN_PACKAGE_ROOT);
            return false;
        }
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        if (!instance.isOptionEnabled(mixin)) {
            return false;
        }
        String disabledBecauseMod = ModernFixMixinPlugin.instance.config.getPermanentlyDisabledMixins().get(mixin);
        return disabledBecauseMod == null;
    }

    public boolean isOptionEnabled(String mixin) {
        Option option = ModernFixMixinPlugin.instance.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            String msg = "No rules matched mixin '{}', treating as foreign and disabling!";
            if (ModernFixPlatformHooks.INSTANCE.isDevEnv()) {
                this.logger.error(msg, (Object)mixin);
            } else {
                this.logger.debug(msg, (Object)mixin);
            }
            return false;
        }
        return option.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (mixinClassName.equals("org.embeddedt.modernfix.common.mixin.perf.reduce_blockstate_cache_rebuilds.BlockStateBaseMixin")) {
            try {
                this.applyBlockStateCacheScan(targetClass);
            }
            catch (RuntimeException e) {
                ModernFixMixinPlugin.instance.logger.error("Applying blockstate cache ASM patch failed", (Throwable)e);
            }
        }
        ModernFixPlatformHooks.INSTANCE.applyASMTransformers(mixinClassName, targetClass);
    }

    private void applyBlockStateCacheScan(ClassNode targetClass) {
        ImmutableSet initCacheMethodNames = ImmutableSet.of((Object)"m_60611_", (Object)"func_215692_c", (Object)"method_26200", (Object)"initCache");
        ImmutableSet whitelistedInjections = ImmutableSet.of((Object)"getFluidState", (Object)"method_26227", (Object)"m_60819_", (Object)"func_204520_s");
        HashMap<String, Object> injectorMethodNames = new HashMap<String, Object>();
        HashMap<String, Object> allMethods = new HashMap<String, Object>();
        HashMap<String, String> injectorMixinSource = new HashMap<String, String>();
        String descriptor = Type.getDescriptor(MixinMerged.class);
        for (Object m : targetClass.methods) {
            if ((((MethodNode)m).access & 8) != 0) continue;
            allMethods.put(((MethodNode)m).name, m);
            HashSet<AnnotationNode> seenNodes = new HashSet<AnnotationNode>();
            if (((MethodNode)m).invisibleAnnotations != null) {
                for (AnnotationNode ann : ((MethodNode)m).invisibleAnnotations) {
                    if (!ann.desc.equals(descriptor)) continue;
                    seenNodes.add(ann);
                }
            }
            if (((MethodNode)m).visibleAnnotations != null) {
                for (AnnotationNode ann : ((MethodNode)m).visibleAnnotations) {
                    if (!ann.desc.equals(descriptor)) continue;
                    seenNodes.add(ann);
                }
            }
            if (seenNodes.size() <= 0) continue;
            injectorMethodNames.put(((MethodNode)m).name, m);
            block3: for (AnnotationNode node : seenNodes) {
                for (int i = 0; i < node.values.size(); i += 2) {
                    if (!Objects.equals(node.values.get(i), "mixin")) continue;
                    injectorMixinSource.put(((MethodNode)m).name, (String)node.values.get(i + 1));
                    continue block3;
                }
            }
        }
        HashSet<String> cacheCalledInjectors = new HashSet<String>();
        for (MethodNode m : targetClass.methods) {
            if ((m.access & 8) != 0 || !initCacheMethodNames.contains(m.name)) continue;
            for (AbstractInsnNode n : m.instructions) {
                if (!(n instanceof MethodInsnNode)) continue;
                MethodInsnNode invoke = (MethodInsnNode)n;
                if (!((MethodInsnNode)n).owner.equals(targetClass.name) || !injectorMethodNames.containsKey(((MethodInsnNode)n).name)) continue;
                cacheCalledInjectors.add(invoke.name);
            }
        }
        HashSet accessedFieldNames = new HashSet();
        HashMap<String, MethodNode> writingMethods = new HashMap<String, MethodNode>(injectorMethodNames);
        writingMethods.keySet().retainAll(cacheCalledInjectors);
        int previousSize = 0;
        HashSet<String> checkedCalls = new HashSet<String>();
        while (writingMethods.size() > previousSize) {
            previousSize = writingMethods.size();
            ArrayList keysToCheck = new ArrayList(writingMethods.keySet());
            for (String name2 : keysToCheck) {
                if (!checkedCalls.add(name2)) continue;
                for (AbstractInsnNode n : ((MethodNode)writingMethods.get((Object)name2)).instructions) {
                    MethodNode theMethod;
                    if (!(n instanceof MethodInsnNode)) continue;
                    MethodInsnNode invokeNode = (MethodInsnNode)n;
                    if (!invokeNode.owner.equals(targetClass.name) || (theMethod = (MethodNode)allMethods.get(invokeNode.name)) == null) continue;
                    writingMethods.put(invokeNode.name, theMethod);
                }
            }
        }
        writingMethods.forEach((name, method) -> {
            for (AbstractInsnNode n : method.instructions) {
                FieldInsnNode fieldAcc;
                if (!(n instanceof FieldInsnNode) || (fieldAcc = (FieldInsnNode)n).getOpcode() != 181 || !fieldAcc.owner.equals(targetClass.name)) continue;
                accessedFieldNames.add(fieldAcc.name);
            }
        });
        injectorMethodNames.forEach((arg_0, arg_1) -> ModernFixMixinPlugin.lambda$applyBlockStateCacheScan$2((Set)whitelistedInjections, cacheCalledInjectors, accessedFieldNames, injectorMixinSource, targetClass, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$applyBlockStateCacheScan$2(Set whitelistedInjections, Set cacheCalledInjectors, Set accessedFieldNames, Map injectorMixinSource, ClassNode targetClass, String name, MethodNode method) {
        if (whitelistedInjections.contains(name) || cacheCalledInjectors.contains(name)) {
            return;
        }
        boolean needInjection = false;
        for (AbstractInsnNode n : method.instructions) {
            FieldInsnNode fieldAcc;
            if (!(n instanceof FieldInsnNode) || (fieldAcc = (FieldInsnNode)n).getOpcode() != 180 || !accessedFieldNames.contains(fieldAcc.name)) continue;
            needInjection = true;
            break;
        }
        if (needInjection) {
            ModernFixMixinPlugin.instance.logger.info("Injecting BlockStateBase cache population hook into {} from {}", (Object)name, (Object)injectorMixinSource.getOrDefault(name, "[unknown mixin]"));
            InsnList injection = new InsnList();
            injection.add((AbstractInsnNode)new VarInsnNode(25, 0));
            injection.add((AbstractInsnNode)new MethodInsnNode(182, targetClass.name, "mfix$generateCache", "()V"));
            method.instructions.insert(injection);
        }
    }
}

