/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.faster_texture_loading;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AtlasTexture.class}, priority=600)
@ClientOnlyMixin
public abstract class TextureAtlasMixin {
    private Map<ResourceLocation, Pair<IResource, NativeImage>> loadedImages = new ConcurrentHashMap<ResourceLocation, Pair<IResource, NativeImage>>();
    private boolean usingFasterLoad;
    private Collection<TextureAtlasSprite.Info> storedResults;

    @Shadow
    protected abstract ResourceLocation func_195420_b(ResourceLocation var1);

    @Shadow
    protected abstract Collection<TextureAtlasSprite.Info> func_215256_a(IResourceManager var1, Set<ResourceLocation> var2);

    @Inject(method={"getBasicSpriteInfos"}, at={@At(value="HEAD")})
    private void loadImages(IResourceManager manager, Set<ResourceLocation> imageLocations, CallbackInfoReturnable<Collection<TextureAtlasSprite.Info>> cir) {
        this.usingFasterLoad = ModernFixPlatformHooks.INSTANCE.isLoadingNormally();
    }

    @Redirect(method={"getBasicSpriteInfos"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;", ordinal=0))
    private Iterator<?> skipIteration(Set<?> instance, IResourceManager manager, Set<ResourceLocation> imageLocations) {
        if (!this.usingFasterLoad) {
            return instance.iterator();
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ConcurrentLinkedQueue<TextureAtlasSprite.Info> results = new ConcurrentLinkedQueue<TextureAtlasSprite.Info>();
        for (ResourceLocation location : imageLocations) {
            if (MissingTextureSprite.func_195675_b().equals((Object)location)) continue;
            futures.add(CompletableFuture.runAsync(() -> {
                try {
                    ResourceLocation fileLocation = this.func_195420_b(location);
                    IResource resource = manager.func_199002_a(fileLocation);
                    NativeImage image = NativeImage.func_195713_a((InputStream)resource.func_199027_b());
                    AnimationMetadataSection animData = (AnimationMetadataSection)resource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                    if (animData == null) {
                        animData = AnimationMetadataSection.field_229300_b_;
                    }
                    Pair dimensions = animData.func_225641_a_(image.func_195702_a(), image.func_195714_b());
                    this.loadedImages.put(location, (Pair<IResource, NativeImage>)Pair.of((Object)resource, (Object)image));
                    results.add(new TextureAtlasSprite.Info(location, ((Integer)dimensions.getFirst()).intValue(), ((Integer)dimensions.getSecond()).intValue(), animData));
                }
                catch (IOException e) {
                    ModernFix.LOGGER.error("Using missing texture, unable to load {} : {}", (Object)location, (Object)e);
                }
                catch (RuntimeException e) {
                    ModernFix.LOGGER.error("Unable to parse metadata from {} : {}", (Object)location, (Object)e);
                }
            }, ModernFix.resourceReloadExecutor()));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        this.storedResults = results;
        return Collections.emptyIterator();
    }

    @Inject(method={"getBasicSpriteInfos"}, at={@At(value="RETURN")})
    private void injectFastSprites(IResourceManager resourceManager, Set<ResourceLocation> spriteLocations, CallbackInfoReturnable<Collection<TextureAtlasSprite.Info>> cir) {
        if (this.usingFasterLoad) {
            ((Collection)cir.getReturnValue()).addAll(this.storedResults);
        }
    }

    @Inject(method={"prepareToStitch"}, at={@At(value="HEAD")})
    private void initMap(CallbackInfoReturnable<AtlasTexture.SheetData> cir) {
        this.loadedImages = new ConcurrentHashMap<ResourceLocation, Pair<IResource, NativeImage>>();
    }

    @Inject(method={"prepareToStitch"}, at={@At(value="RETURN")})
    private void clearLoadedImages(CallbackInfoReturnable<AtlasTexture.SheetData> cir) {
        this.loadedImages = Collections.emptyMap();
        this.storedResults = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlas;getResourceLocation(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/resources/ResourceLocation;")}, cancellable=true)
    private void loadFromExisting(IResourceManager resourceManager, TextureAtlasSprite.Info spriteInfo, int width, int height, int mipmapLevel, int originX, int originY, CallbackInfoReturnable<TextureAtlasSprite> cir) {
        if (!this.usingFasterLoad) {
            return;
        }
        Pair<IResource, NativeImage> pair = this.loadedImages.get(spriteInfo.func_229248_a_());
        if (pair == null) {
            ModernFix.LOGGER.error("Texture {} was not loaded in early stage", (Object)spriteInfo.func_229248_a_());
            cir.setReturnValue(null);
        } else {
            TextureAtlasSprite sprite = null;
            try {
                sprite = ModernFixPlatformHooks.INSTANCE.loadTextureAtlasSprite((AtlasTexture)this, resourceManager, spriteInfo, (IResource)pair.getFirst(), width, height, originX, originY, mipmapLevel, (NativeImage)pair.getSecond());
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Error loading texture {}: {}", (Object)spriteInfo.func_229248_a_(), (Object)e);
            }
            finally {
                try {
                    ((IResource)pair.getFirst()).close();
                }
                catch (IOException iOException) {}
            }
            cir.setReturnValue(sprite);
        }
    }
}

