/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_sounds;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.AudioStreamManager;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AudioStreamManager.class})
@ClientOnlyMixin
public abstract class SoundBufferLibraryMixin {
    private static final boolean debugDynamicSoundLoading = Boolean.getBoolean("modernfix.debugDynamicSoundLoading");
    @Shadow
    @Final
    @Mutable
    private Map<ResourceLocation, CompletableFuture<AudioStreamBuffer>> field_217919_b = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).concurrencyLevel(1).removalListener(this::onSoundRemoval).build().asMap();

    private <K extends ResourceLocation, V extends CompletableFuture<AudioStreamBuffer>> void onSoundRemoval(RemovalNotification<K, V> notification) {
        if (notification.getCause() == RemovalCause.REPLACED && notification.getValue() == this.field_217919_b.get(notification.getKey())) {
            return;
        }
        ((CompletableFuture)notification.getValue()).thenAccept(AudioStreamBuffer::func_216474_b);
        if (!debugDynamicSoundLoading) {
            return;
        }
        ResourceLocation k = (ResourceLocation)notification.getKey();
        if (k == null) {
            return;
        }
        ModernFix.LOGGER.warn("Evicted sound {}", (Object)k);
    }
}

