/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.action;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import thetadev.constructionwand.api.IWandAction;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.wand.undo.ISnapshot;
import thetadev.constructionwand.wand.undo.PlaceSnapshot;

public class ActionAngel
implements IWandAction {
    @Override
    public int getLimit(ItemStack wand) {
        return ConfigServer.getWandProperties(wand.func_77973_b()).getAngel();
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshots(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        Direction placeDirection = rayTraceResult.func_216354_b();
        BlockPos currentPos = rayTraceResult.func_216350_a();
        BlockState supportingBlock = world.func_180495_p(currentPos);
        for (int i = 0; i < limit; ++i) {
            PlaceSnapshot snapshot = supplier.getPlaceSnapshot(world, currentPos = currentPos.func_177972_a(placeDirection.func_176734_d()), rayTraceResult, supportingBlock);
            if (snapshot == null) continue;
            placeSnapshots.add(snapshot);
            break;
        }
        return placeSnapshots;
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshotsFromAir(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        Vector3d lookVec;
        LinkedList<ISnapshot> placeSnapshots = new LinkedList<ISnapshot>();
        if (!player.func_184812_l_() && !((Boolean)ConfigServer.ANGEL_FALLING.get()).booleanValue() && player.field_70143_R > 10.0f) {
            return placeSnapshots;
        }
        Vector3d playerVec = WandUtil.entityPositionVec((Entity)player);
        Vector3d placeVec = playerVec.func_178787_e(lookVec = player.func_70040_Z().func_216372_d(2.0, 2.0, 2.0));
        BlockPos currentPos = new BlockPos(placeVec);
        PlaceSnapshot snapshot = supplier.getPlaceSnapshot(world, currentPos, rayTraceResult, null);
        if (snapshot != null) {
            placeSnapshots.add(snapshot);
        }
        return placeSnapshots;
    }
}

