/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics.option;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandUpgrade;

public class WandUpgrades<T extends IWandUpgrade> {
    protected final CompoundNBT tag;
    protected final String key;
    protected final ArrayList<T> upgrades;
    protected final T dval;

    public WandUpgrades(CompoundNBT tag, String key, T dval) {
        this.tag = tag;
        this.key = key;
        this.dval = dval;
        this.upgrades = new ArrayList();
        if (dval != null) {
            this.upgrades.add(0, dval);
        }
        this.deserialize();
    }

    protected void deserialize() {
        ListNBT listnbt = this.tag.func_150295_c(this.key, 8);
        boolean require_fix = false;
        for (int i = 0; i < listnbt.size(); ++i) {
            String str = listnbt.func_150307_f(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(str));
            try {
                IWandUpgrade data = (IWandUpgrade)item;
                this.upgrades.add(data);
                continue;
            }
            catch (ClassCastException e) {
                ConstructionWand.LOGGER.warn("Invalid wand upgrade: " + str);
                require_fix = true;
            }
        }
        if (require_fix) {
            this.serialize();
        }
    }

    protected void serialize() {
        ListNBT listnbt = new ListNBT();
        for (IWandUpgrade item : this.upgrades) {
            if (item == this.dval) continue;
            listnbt.add((Object)StringNBT.func_229705_a_((String)item.getRegistryName().toString()));
        }
        this.tag.func_218657_a(this.key, (INBT)listnbt);
    }

    public boolean addUpgrade(T upgrade) {
        if (this.hasUpgrade(upgrade)) {
            return false;
        }
        this.upgrades.add(upgrade);
        this.serialize();
        return true;
    }

    public boolean hasUpgrade(T upgrade) {
        return this.upgrades.contains(upgrade);
    }

    public ArrayList<T> getUpgrades() {
        return this.upgrades;
    }
}

