/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.tool.BaseSwordItem;
import com.blakebr0.mysticalagriculture.api.soul.ISoulSiphoningItem;
import com.blakebr0.mysticalagriculture.lib.ModItemTier;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SouliumDaggerItem
extends BaseSwordItem
implements ISoulSiphoningItem {
    private final DaggerType type;

    public SouliumDaggerItem(IItemTier tier, DaggerType type, Function<Item.Properties, Item.Properties> properties) {
        super(tier, type.getDamage(), -2.4f, properties.compose(p -> p.func_200915_b(type.getDurability())));
        this.type = type;
    }

    public String func_77667_c(ItemStack stack) {
        return "item.mysticalagriculture.soulium_dagger";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        switch (this.type) {
            case BASIC: {
                break;
            }
            case PASSIVE: {
                tooltip.add((ITextComponent)ModTooltips.PASSIVE_ATTUNED.color(TextFormatting.GREEN).build());
                tooltip.add((ITextComponent)ModTooltips.PASSIVE_SOULIUM_DAGGER.build());
                break;
            }
            case HOSTILE: {
                tooltip.add((ITextComponent)ModTooltips.HOSTILE_ATTUNED.color(TextFormatting.RED).build());
                tooltip.add((ITextComponent)ModTooltips.HOSTILE_SOULIUM_DAGGER.build());
                break;
            }
            case CREATIVE: {
                tooltip.add((ITextComponent)ModTooltips.CREATIVE_ATTUNED.color(TextFormatting.LIGHT_PURPLE).build());
                tooltip.add((ITextComponent)ModTooltips.CREATIVE_SOULIUM_DAGGER.build());
            }
        }
    }

    @Override
    public double getSiphonAmount(ItemStack stack, LivingEntity entity) {
        return this.type.getSiphonAmount(stack, entity);
    }

    public static enum DaggerType {
        BASIC(3, ModItemTier.SOULIUM.func_200926_a(), (stack, entity) -> 1.0),
        PASSIVE(6, ModItemTier.SOULIUM.func_200926_a() * 2, (stack, entity) -> DaggerType.isPassive(entity) ? 1.5 : 1.0),
        HOSTILE(6, ModItemTier.SOULIUM.func_200926_a() * 2, (stack, entity) -> !DaggerType.isPassive(entity) ? 1.5 : 1.0),
        CREATIVE(65, -1, (stack, entity) -> Double.MAX_VALUE);

        private final int damage;
        private final int durability;
        private final BiFunction<ItemStack, LivingEntity, Double> siphonAmountFunc;

        private DaggerType(int damage, int durability, BiFunction<ItemStack, LivingEntity, Double> siphonAmountFunc) {
            this.damage = damage;
            this.durability = durability;
            this.siphonAmountFunc = siphonAmountFunc;
        }

        public double getSiphonAmount(ItemStack stack, LivingEntity entity) {
            return this.siphonAmountFunc.apply(stack, entity);
        }

        public int getDamage() {
            return this.damage;
        }

        public int getDurability() {
            return this.durability;
        }

        private static boolean isPassive(LivingEntity entity) {
            return entity.getClassification(false).func_75599_d();
        }
    }
}

