/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class CropComponentIngredient
extends Ingredient {
    private final ICrop crop;
    private final ComponentType type;

    public CropComponentIngredient(ICrop crop, ComponentType type) {
        super(Stream.empty());
        this.crop = crop;
        this.type = type;
    }

    public CropComponentIngredient(ICrop crop, ComponentType type, Stream<Ingredient.IItemList> itemList) {
        super(itemList);
        this.crop = crop;
        this.type = type;
    }

    public boolean test(ItemStack input) {
        if (input == null) {
            return false;
        }
        if (!super.test(input)) {
            return false;
        }
        return Arrays.stream(this.func_193365_a()).anyMatch(s -> s.func_77952_i() == input.func_77952_i() && (!s.func_77942_o() || s.areShareTagsEqual(input)));
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "mysticalagriculture:crop_component");
        json.addProperty("component", this.type.name);
        json.addProperty("crop", this.crop.getId().toString());
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.CROP_COMPONENT_INGREDIENT;
    }

    public static enum ComponentType {
        ESSENCE("essence"),
        SEED("seed"),
        MATERIAL("material");

        private static final Map<String, ComponentType> LOOKUP;
        public final String name;

        private ComponentType(String name) {
            this.name = name;
        }

        public static ComponentType fromName(String name) {
            return LOOKUP.get(name);
        }

        static {
            LOOKUP = new HashMap<String, ComponentType>();
            for (ComponentType value : ComponentType.values()) {
                LOOKUP.put(value.name, value);
            }
        }
    }

    public static class Serializer
    implements IIngredientSerializer<CropComponentIngredient> {
        public CropComponentIngredient parse(PacketBuffer buffer) {
            ICrop crop = CropRegistry.getInstance().getCropById(new ResourceLocation(buffer.func_218666_n()));
            ComponentType type = ComponentType.fromName(buffer.func_218666_n());
            Stream<Ingredient.IItemList> itemList = Stream.generate(() -> ((PacketBuffer)buffer).func_150791_c()).limit(buffer.func_150792_a()).map(Ingredient.SingleItemList::new);
            return new CropComponentIngredient(crop, type, itemList);
        }

        public CropComponentIngredient parse(JsonObject json) {
            String cropId = JSONUtils.func_151200_h((JsonObject)json, (String)"crop");
            String typeName = JSONUtils.func_151200_h((JsonObject)json, (String)"component");
            ICrop crop = CropRegistry.getInstance().getCropById(new ResourceLocation(cropId));
            ComponentType type = ComponentType.fromName(typeName);
            Ingredient.IItemList itemList = null;
            switch (type) {
                case ESSENCE: {
                    itemList = new Ingredient.SingleItemList(new ItemStack((IItemProvider)crop.getTier().getEssence()));
                    break;
                }
                case SEED: {
                    itemList = new Ingredient.SingleItemList(new ItemStack((IItemProvider)crop.getType().getCraftingSeed()));
                    break;
                }
                case MATERIAL: {
                    itemList = crop.getLazyIngredient().createItemList();
                }
            }
            if (itemList == null) {
                return new CropComponentIngredient(crop, type);
            }
            return new CropComponentIngredient(crop, type, Stream.of(itemList));
        }

        public void write(PacketBuffer buffer, CropComponentIngredient ingredient) {
            buffer.func_180714_a(ingredient.crop.getId().toString());
            buffer.func_180714_a(((CropComponentIngredient)ingredient).type.name);
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack item : items) {
                buffer.func_150788_a(item);
            }
        }
    }
}

