/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.crop.ICropGetter;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.block.MysticalCropBlock;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@WailaPlugin
public class HwylaCompat
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider(new IComponentProvider(){

            public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
                ItemStack stack = accessor.getStack();
                StringTextComponent text = new StringTextComponent("\u00a7f" + stack.func_200301_q().getString());
                tooltip.set(0, (ITextComponent)text);
            }
        }, TooltipPosition.HEAD, MysticalCropBlock.class);
        registrar.registerComponentProvider(new IComponentProvider(){

            public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
                Biome biome;
                Set<ResourceLocation> biomes;
                Block crux;
                Block block = accessor.getBlock();
                ICrop crop = ((ICropGetter)block).getCrop();
                tooltip.add((ITextComponent)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
                BlockPos pos = accessor.getPosition();
                BlockPos downPos = pos.func_177977_b();
                World world = accessor.getWorld();
                Block belowBlock = world.func_180495_p(downPos).func_177230_c();
                double secondaryChance = crop.getSecondaryChance(belowBlock);
                if (secondaryChance > 0.0) {
                    IFormattableTextComponent chanceText = new StringTextComponent(String.valueOf((int)(secondaryChance * 100.0))).func_240702_b_("%").func_240699_a_(crop.getTier().getTextColor());
                    tooltip.add((ITextComponent)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
                }
                if ((crux = crop.getCrux()) != null) {
                    ItemStack stack = new ItemStack((IItemProvider)crux);
                    tooltip.add((ITextComponent)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack.func_200301_q()}).build());
                }
                if (!(biomes = crop.getRequiredBiomes()).isEmpty() && !biomes.contains((biome = world.func_226691_t_(pos)).getRegistryName())) {
                    tooltip.add((ITextComponent)ModTooltips.INVALID_BIOME.color(TextFormatting.RED).build());
                }
            }
        }, TooltipPosition.BODY, MysticalCropBlock.class);
        registrar.registerComponentProvider(new IComponentProvider(){

            public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
                Block block = accessor.getBlock();
                ICrop crop = ((ICropGetter)block).getCrop();
                BlockPos downPos = accessor.getPosition().func_177977_b();
                Block belowBlock = accessor.getWorld().func_180495_p(downPos).func_177230_c();
                int output = 100;
                if (belowBlock instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)belowBlock;
                    int tier = farmland.getTier().getValue();
                    output = tier * 50 + 50;
                }
                IFormattableTextComponent inferiumOutputText = new StringTextComponent(String.valueOf(output)).func_240702_b_("%").func_240699_a_(crop.getTier().getTextColor());
                tooltip.add((ITextComponent)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
            }
        }, TooltipPosition.BODY, InferiumCropBlock.class);
        registrar.registerComponentProvider(new IComponentProvider(){

            public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
                Block block = accessor.getBlock();
                IEssenceFarmland farmland = (IEssenceFarmland)block;
                tooltip.add((ITextComponent)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
            }
        }, TooltipPosition.BODY, IEssenceFarmland.class);
    }
}

