/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.crop.ICropGetter;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class MysticalCropBlock
extends CropsBlock
implements ICropGetter {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private final ICrop crop;

    public MysticalCropBlock(ICrop crop) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150464_aj));
        this.crop = crop;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!this.canGrow((World)world, pos)) {
            return;
        }
        super.func_225542_b_(state, world, pos, random);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public String func_149739_a() {
        return Localizable.of((String)"block.mysticalagriculture.mystical_crop").args(new Object[]{this.crop.getDisplayName()}).buildString();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        int age = (Integer)state.func_177229_b((Property)field_176488_a);
        int crop = 0;
        int seed = 1;
        int fertilizer = 0;
        if (age == this.func_185526_g()) {
            crop = 1;
            Vector3d vec = (Vector3d)builder.func_216019_b(LootParameters.field_237457_g_);
            if (vec != null) {
                ServerWorld world = builder.func_216018_a();
                BlockPos pos = new BlockPos(vec);
                Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
                double chance = this.crop.getSecondaryChance(below);
                if (Math.random() < chance) {
                    crop = 2;
                }
                if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && Math.random() < chance) {
                    seed = 2;
                }
                double fertilizerChance = (Double)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE.get();
                if (Math.random() < fertilizerChance) {
                    fertilizer = 1;
                }
            }
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (crop > 0) {
            drops.add(new ItemStack(this.getCropsItem(), crop));
        }
        drops.add(new ItemStack(this.func_199772_f(), seed));
        if (fertilizer > 0) {
            drops.add(new ItemStack((IItemProvider)ModItems.FERTILIZED_ESSENCE.get()));
        }
        return drops;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if (!this.canGrow((World)world, pos)) {
            return;
        }
        super.func_225535_a_(world, rand, pos, state);
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        if (world instanceof World) {
            return this.canGrow((World)world, pos) && super.func_176473_a(world, pos, state, isClient);
        }
        return super.func_176473_a(world, pos, state, isClient);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c() instanceof FarmlandBlock;
    }

    protected IItemProvider func_199772_f() {
        return this.crop.getSeeds();
    }

    @Override
    public ICrop getCrop() {
        return this.crop;
    }

    protected IItemProvider getCropsItem() {
        return this.crop.getEssence();
    }

    private boolean canGrow(World world, BlockPos pos) {
        Block block;
        Block crux = this.crop.getCrux();
        if (crux != null && (block = world.func_180495_p(pos.func_177979_c(2)).func_177230_c()) != crux) {
            return false;
        }
        Set<ResourceLocation> biomes = this.crop.getRequiredBiomes();
        if (!biomes.isEmpty()) {
            Biome biome = world.func_226691_t_(pos);
            return biomes.contains(biome.getRegistryName());
        }
        return true;
    }
}

