/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.soul;

import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSoulType
implements IMobSoulType {
    private final ResourceLocation id;
    private final Set<ResourceLocation> entityIds;
    private double soulRequirement;
    private int color;
    private String entityDisplayNameKey = null;
    private ITextComponent entityDisplayName = null;
    private boolean enabled;

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Sets.newHashSet((Object[])new ResourceLocation[]{entityId});
        this.soulRequirement = soulRequirement;
        this.color = color;
        this.enabled = true;
    }

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Sets.newHashSet((Object[])new ResourceLocation[]{entityId});
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = color;
        this.enabled = true;
    }

    public MobSoulType(ResourceLocation id, Set<ResourceLocation> entityIds, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = entityIds;
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = color;
        this.enabled = true;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Set<ResourceLocation> getEntityIds() {
        return this.entityIds;
    }

    @Override
    public double getSoulRequirement() {
        return this.soulRequirement;
    }

    @Override
    public IMobSoulType setSoulRequirement(double soulRequirement) {
        this.soulRequirement = soulRequirement;
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public IMobSoulType setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public boolean isEntityApplicable(LivingEntity entity) {
        return this.entityIds.contains(entity.func_200600_R().getRegistryName());
    }

    @Override
    public ITextComponent getEntityDisplayName() {
        if (this.entityDisplayName == null) {
            if (this.entityDisplayNameKey != null) {
                this.entityDisplayName = new TranslationTextComponent(String.format("mobSoulType.%s.%s", this.getModId(), this.entityDisplayNameKey));
            } else {
                EntityType entity;
                ResourceLocation entityId = this.entityIds.stream().findFirst().orElse(null);
                if (entityId != null && (entity = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId)) != null) {
                    this.entityDisplayName = entity.func_212546_e();
                    return this.entityDisplayName;
                }
                this.entityDisplayName = new TranslationTextComponent("tooltip.mysticalagriculture.invalid_entity");
            }
        }
        return this.entityDisplayName;
    }

    @Override
    public MobSoulType setEntityDisplayName(ITextComponent name) {
        this.entityDisplayName = name;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public IMobSoulType setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

