/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.simplescreens;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.jarhax.simplescreens.Constants;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    @SerializedName(value="game_load_screen_textures")
    public List<String> gameLoadScreenTextures = Config.of("simplescreens:textures/gui/load_screens/game_load_background.png");
    @Expose
    @SerializedName(value="world_load_screen_textures")
    public List<String> worldLoadScreenTextures = Config.of("simplescreens:textures/gui/load_screens/world_load_background.png");

    public static Config load() {
        Throwable throwable;
        File configFile = FMLPaths.CONFIGDIR.get().resolve("simplescreens.json").toFile();
        Config config = new Config();
        if (configFile.exists()) {
            try {
                throwable = null;
                try (FileReader reader = new FileReader(configFile);){
                    config = (Config)GSON.fromJson((Reader)reader, Config.class);
                    Constants.LOG.info("Loaded config file.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                Constants.LOG.catching((Throwable)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try {
            throwable = null;
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)config, (Appendable)writer);
                Constants.LOG.info("Saved config file.");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.catching((Throwable)e);
        }
        return config;
    }

    private static List<String> of(String ... elements) {
        ArrayList<String> list = new ArrayList<String>();
        Arrays.stream(elements).forEach(list::add);
        return list;
    }
}

