/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.blocks.CookingPotBlock;
import vectorwing.farmersdelight.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.mixin.accessors.RecipeManagerAccessor;
import vectorwing.farmersdelight.registry.ModParticleTypes;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.FDSyncedTileEntity;
import vectorwing.farmersdelight.tile.IHeatableTileEntity;
import vectorwing.farmersdelight.tile.container.CookingPotContainer;
import vectorwing.farmersdelight.tile.inventory.CookingPotItemHandler;
import vectorwing.farmersdelight.utils.ItemUtils;
import vectorwing.farmersdelight.utils.TextUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CookingPotTileEntity
extends FDSyncedTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
IHeatableTileEntity,
INameable {
    public static final int MEAL_DISPLAY_SLOT = 6;
    public static final int CONTAINER_SLOT = 7;
    public static final int OUTPUT_SLOT = 8;
    public static final int INVENTORY_SIZE = 9;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new CookingPotItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new CookingPotItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private int cookTime;
    private int cookTimeTotal;
    private ItemStack mealContainerStack = ItemStack.field_190927_a;
    private ITextComponent customName;
    protected final IIntArray cookingPotData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> experienceTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe;

    public CookingPotTileEntity() {
        super((TileEntityType)ModTileEntityTypes.COOKING_POT_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.mealContainerStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Container"));
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        CompoundNBT compoundRecipes = compound.func_74775_l("RecipesUsed");
        for (String key : compoundRecipes.func_150296_c()) {
            this.experienceTracker.put((Object)new ResourceLocation(key), compoundRecipes.func_74762_e(key));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_218657_a("Container", (INBT)this.mealContainerStack.serializeNBT());
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        CompoundNBT compoundRecipes = new CompoundNBT();
        this.experienceTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.func_74768_a(recipeId.toString(), craftedAmount.intValue()));
        compound.func_218657_a("RecipesUsed", (INBT)compoundRecipes);
        return compound;
    }

    private CompoundNBT writeItems(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Container", (INBT)this.mealContainerStack.serializeNBT());
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundNBT writeMeal(CompoundNBT compound) {
        if (this.getMeal().func_190926_b()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(9);
        for (int i = 0; i < 9; ++i) {
            drops.setStackInSlot(i, i == 6 ? this.inventory.getStackInSlot(i) : ItemStack.field_190927_a);
        }
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_218657_a("Container", (INBT)this.mealContainerStack.serializeNBT());
        compound.func_218657_a("Inventory", (INBT)drops.serializeNBT());
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        boolean isHeated = this.isHeated(this.field_145850_b, this.field_174879_c);
        boolean didInventoryChange = false;
        if (!this.field_145850_b.field_72995_K) {
            if (isHeated && this.hasInput()) {
                Optional<CookingPotRecipe> recipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)this.inventory));
                if (recipe.isPresent() && this.canCook(recipe.get())) {
                    didInventoryChange = this.processCooking(recipe.get());
                } else {
                    this.cookTime = 0;
                }
            } else if (this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            ItemStack mealStack = this.getMeal();
            if (!mealStack.func_190926_b()) {
                if (!this.doesMealHaveContainer(mealStack)) {
                    this.moveMealToOutput();
                    didInventoryChange = true;
                } else if (!this.inventory.getStackInSlot(7).func_190926_b()) {
                    this.useStoredContainersOnMeal();
                    didInventoryChange = true;
                }
            }
        } else if (isHeated) {
            this.animate();
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    private Optional<CookingPotRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.field_145850_b == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.field_145850_b.func_199532_z()).getRecipeMap(CookingPotRecipe.TYPE).get(this.lastRecipeID)) instanceof CookingPotRecipe) {
            if (recipe.func_77569_a((IInventory)inventoryWrapper, this.field_145850_b)) {
                return Optional.of((CookingPotRecipe)recipe);
            }
            if (recipe.func_77571_b().func_77969_a(this.getMeal())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.field_145850_b.func_199532_z().func_215371_a(CookingPotRecipe.TYPE, (IInventory)inventoryWrapper, this.field_145850_b))).isPresent()) {
            this.lastRecipeID = ((CookingPotRecipe)((Optional)recipe).get()).func_199560_c();
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public ItemStack getContainer() {
        if (!this.mealContainerStack.func_190926_b()) {
            return this.mealContainerStack;
        }
        return this.getMeal().getContainerItem();
    }

    private boolean hasInput() {
        for (int i = 0; i < 6; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(CookingPotRecipe recipe) {
        if (this.hasInput()) {
            ItemStack resultStack = recipe.func_77571_b();
            if (resultStack.func_190926_b()) {
                return false;
            }
            ItemStack storedMealStack = this.inventory.getStackInSlot(6);
            if (storedMealStack.func_190926_b()) {
                return true;
            }
            if (!storedMealStack.func_77969_a(resultStack)) {
                return false;
            }
            if (storedMealStack.func_190916_E() + resultStack.func_190916_E() <= this.inventory.getSlotLimit(6)) {
                return true;
            }
            return storedMealStack.func_190916_E() + resultStack.func_190916_E() <= resultStack.func_77976_d();
        }
        return false;
    }

    private boolean processCooking(CookingPotRecipe recipe) {
        if (this.field_145850_b == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = recipe.getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.func_77571_b();
        ItemStack storedMealStack = this.inventory.getStackInSlot(6);
        if (storedMealStack.func_190926_b()) {
            this.inventory.setStackInSlot(6, resultStack.func_77946_l());
        } else if (storedMealStack.func_77969_a(resultStack)) {
            storedMealStack.func_190917_f(resultStack.func_190916_E());
        }
        this.trackRecipeExperience(recipe);
        for (int i = 0; i < 6; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasContainerItem()) {
                Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)CookingPotBlock.field_185512_D)).func_176735_f();
                double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.25;
                double y = (double)this.field_174879_c.func_177956_o() + 0.7;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.25;
                ItemUtils.spawnItemEntity(this.field_145850_b, this.inventory.getStackInSlot(i).getContainerItem(), x, y, z, (float)direction.func_82601_c() * 0.08f, 0.25, (float)direction.func_82599_e() * 0.08f);
            }
            if (slotStack.func_190926_b()) continue;
            slotStack.func_190918_g(1);
        }
        return true;
    }

    private void animate() {
        double z;
        double y;
        double x;
        if (this.field_145850_b == null) {
            return;
        }
        Random random = this.field_145850_b.field_73012_v;
        if (random.nextFloat() < 0.2f) {
            x = (double)this.field_174879_c.func_177958_n() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            y = (double)this.field_174879_c.func_177956_o() + 0.7;
            z = (double)this.field_174879_c.func_177952_p() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_203217_T, x, y, z, 0.0, 0.0, 0.0);
        }
        if (random.nextFloat() < 0.05f) {
            x = (double)this.field_174879_c.func_177958_n() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
            y = (double)this.field_174879_c.func_177956_o() + 0.5;
            z = (double)this.field_174879_c.func_177952_p() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
            double motionY = random.nextBoolean() ? 0.015 : 0.005;
            this.field_145850_b.func_195594_a((IParticleData)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
        }
    }

    public void trackRecipeExperience(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.func_199560_c();
            this.experienceTracker.addTo((Object)recipeID, 1);
        }
    }

    public void clearUsedRecipes(PlayerEntity player) {
        this.grantStoredRecipeExperience(player.field_70170_p, player.func_213303_ch());
        this.experienceTracker.clear();
    }

    public void grantStoredRecipeExperience(World world, Vector3d pos) {
        for (Object2IntMap.Entry entry : this.experienceTracker.object2IntEntrySet()) {
            world.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(recipe -> CookingPotTileEntity.splitAndSpawnExperience(world, pos, entry.getIntValue(), ((CookingPotRecipe)recipe).getExperience()));
        }
    }

    private static void splitAndSpawnExperience(World world, Vector3d pos, int craftedAmount, float experience) {
        int expTotal = MathHelper.func_76141_d((float)((float)craftedAmount * experience));
        float expFraction = MathHelper.func_226164_h_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        while (expTotal > 0) {
            int expValue = ExperienceOrbEntity.func_70527_a((int)expTotal);
            expTotal -= expValue;
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, expValue));
        }
    }

    public boolean isHeated() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.isHeated(this.field_145850_b, this.field_174879_c);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getMeal() {
        return this.inventory.getStackInSlot(6);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.func_191196_a();
        for (int i = 0; i < 9; ++i) {
            if (i == 6) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(6);
        ItemStack outputStack = this.inventory.getStackInSlot(8);
        int mealCount = Math.min(mealStack.func_190916_E(), mealStack.func_77976_d() - outputStack.func_190916_E());
        if (outputStack.func_190926_b()) {
            this.inventory.setStackInSlot(8, mealStack.func_77979_a(mealCount));
        } else if (outputStack.func_77973_b() == mealStack.func_77973_b()) {
            mealStack.func_190918_g(mealCount);
            outputStack.func_190917_f(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        ItemStack mealStack = this.inventory.getStackInSlot(6);
        ItemStack containerInputStack = this.inventory.getStackInSlot(7);
        ItemStack outputStack = this.inventory.getStackInSlot(8);
        if (this.isContainerValid(containerInputStack) && outputStack.func_190916_E() < outputStack.func_77976_d()) {
            int smallerStackCount = Math.min(mealStack.func_190916_E(), containerInputStack.func_190916_E());
            int mealCount = Math.min(smallerStackCount, mealStack.func_77976_d() - outputStack.func_190916_E());
            if (outputStack.func_190926_b()) {
                containerInputStack.func_190918_g(mealCount);
                this.inventory.setStackInSlot(8, mealStack.func_77979_a(mealCount));
            } else if (outputStack.func_77973_b() == mealStack.func_77973_b()) {
                mealStack.func_190918_g(mealCount);
                containerInputStack.func_190918_g(mealCount);
                outputStack.func_190917_f(mealCount);
            }
        }
    }

    public ItemStack useHeldItemOnMeal(ItemStack container) {
        if (this.isContainerValid(container) && !this.getMeal().func_190926_b()) {
            container.func_190918_g(1);
            return this.getMeal().func_77979_a(1);
        }
        return ItemStack.field_190927_a;
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.mealContainerStack.func_190926_b() || meal.hasContainerItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.func_190926_b()) {
            return false;
        }
        if (!this.mealContainerStack.func_190926_b()) {
            return this.mealContainerStack.func_77969_a(containerItem);
        }
        return this.getMeal().getContainerItem().func_77969_a(containerItem);
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : TextUtils.getTranslation("container.cooking_pot", new Object[0]);
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public Container createMenu(int id, PlayerInventory player, PlayerEntity entity) {
        return new CookingPotContainer(id, player, this, this.cookingPotData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.writeItems(new CompoundNBT());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 6) {
                    CookingPotTileEntity.this.checkNewRecipe = true;
                }
                CookingPotTileEntity.this.inventoryChanged();
            }
        };
    }

    private IIntArray createIntArray() {
        return new IIntArray(){

            public int func_221476_a(int index) {
                switch (index) {
                    case 0: {
                        return CookingPotTileEntity.this.cookTime;
                    }
                    case 1: {
                        return CookingPotTileEntity.this.cookTimeTotal;
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                switch (index) {
                    case 0: {
                        CookingPotTileEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        CookingPotTileEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int func_221478_a() {
                return 2;
            }
        };
    }
}

