/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import vectorwing.farmersdelight.blocks.BasketBlock;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.IBasket;
import vectorwing.farmersdelight.utils.TextUtils;

public class BasketTileEntity
extends LockableLootTileEntity
implements IBasket,
ITickableTileEntity {
    private NonNullList<ItemStack> basketContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int transferCooldown = -1;

    public BasketTileEntity() {
        super((TileEntityType)ModTileEntityTypes.BASKET_TILE.get());
    }

    public static boolean pullItems(IBasket basket, int facingIndex) {
        for (ItemEntity itementity : BasketTileEntity.getCaptureItems(basket, facingIndex)) {
            if (!BasketTileEntity.captureItem((IInventory)basket, itementity)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory destination, ItemStack stack) {
        int i = destination.func_70302_i_();
        for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
            stack = BasketTileEntity.insertStack(destination, stack, j);
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, @Nullable Direction side) {
        if (!inventoryIn.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static ItemStack insertStack(IInventory destination, ItemStack stack, int index) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (BasketTileEntity.canInsertItemInSlot(destination, stack, index, null)) {
            boolean flag = false;
            boolean isDestinationEmpty = destination.func_191420_l();
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                flag = true;
            } else if (BasketTileEntity.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                BasketTileEntity firstBasket;
                if (isDestinationEmpty && destination instanceof BasketTileEntity && !(firstBasket = (BasketTileEntity)destination).mayTransfer()) {
                    int k = 0;
                    firstBasket.setTransferCooldown(8 - k);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    public static boolean captureItem(IInventory inventory, ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack entityItemStack = itemEntity.func_92059_d().func_77946_l();
        ItemStack remainderStack = BasketTileEntity.putStackInInventoryAllSlots(inventory, entityItemStack);
        if (remainderStack.func_190926_b()) {
            flag = true;
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(remainderStack);
        }
        return flag;
    }

    public static List<ItemEntity> getCaptureItems(IBasket basket, int facingIndex) {
        return basket.func_145831_w() == null ? new ArrayList<ItemEntity>() : basket.getFacingCollectionArea(facingIndex).func_197756_d().stream().flatMap(p_200110_1_ -> basket.func_145831_w().func_175647_a(ItemEntity.class, p_200110_1_.func_72317_d(basket.func_96107_aA() - 0.5, basket.func_96109_aB() - 0.5, basket.func_96108_aC() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.basketContents);
        }
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.basketContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.basketContents);
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.basketContents;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.basketContents = itemsIn;
    }

    public int func_70302_i_() {
        return this.basketContents.size();
    }

    protected ITextComponent func_213907_g() {
        return TextUtils.getTranslation("container.basket", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return ChestContainer.func_216992_a((int)id, (PlayerInventory)player, (IInventory)this);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)index, (int)count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    private void updateHopper(Supplier<Boolean> supplier) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.isOnTransferCooldown() && ((Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208180_g)).booleanValue()) {
            boolean flag = false;
            if (!this.isFull()) {
                flag = supplier.get();
            }
            if (flag) {
                this.setTransferCooldown(8);
                this.func_70296_d();
            }
        }
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.basketContents) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            BlockPos blockpos = this.func_174877_v();
            int facing = ((Direction)this.func_195044_w().func_177229_b((Property)BasketBlock.FACING)).func_176745_a();
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-blockpos.func_177958_n()), (double)(-blockpos.func_177956_o()), (double)(-blockpos.func_177952_p()))), (VoxelShape)this.getFacingCollectionArea(facing), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                this.updateHopper(() -> BasketTileEntity.captureItem((IInventory)this, (ItemEntity)entity));
            }
        }
    }

    @Override
    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    @Override
    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    @Override
    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                int facing = ((Direction)this.func_195044_w().func_177229_b((Property)BasketBlock.FACING)).func_176745_a();
                this.updateHopper(() -> BasketTileEntity.pullItems(this, facing));
            }
        }
    }
}

