/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import vectorwing.farmersdelight.client.gui.CookingPotScreen;
import vectorwing.farmersdelight.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.integration.jei.cooking.CookingRecipeCategory;
import vectorwing.farmersdelight.integration.jei.cutting.CuttingRecipeCategory;
import vectorwing.farmersdelight.integration.jei.decomposition.DecompositionDummy;
import vectorwing.farmersdelight.integration.jei.decomposition.DecompositionRecipeCategory;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.tile.container.CookingPotContainer;
import vectorwing.farmersdelight.utils.TextUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("farmersdelight", "jei_plugin");
    private static final Minecraft MC = Minecraft.func_71410_x();

    private static List<IRecipe<?>> findRecipesByType(IRecipeType<?> type) {
        return JEIPlugin.MC.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == type).collect(Collectors.toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CookingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CuttingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new DecompositionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIPlugin.findRecipesByType(CookingPotRecipe.TYPE), CookingRecipeCategory.UID);
        registration.addRecipes(JEIPlugin.findRecipesByType(CuttingBoardRecipe.TYPE), CuttingRecipeCategory.UID);
        registration.addRecipes((Collection)ImmutableList.of((Object)new DecompositionDummy()), DecompositionRecipeCategory.UID);
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.STRAW.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.straw", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.HAM.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.ham", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.SMOKED_HAM.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.ham", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.FLINT_KNIFE.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.IRON_KNIFE.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.DIAMOND_KNIFE.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.NETHERITE_KNIFE.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.GOLDEN_KNIFE.get()), VanillaTypes.ITEM, new ITextComponent[]{TextUtils.getTranslation("jei.info.knife", new Object[0])});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.COOKING_POT.get()), new ResourceLocation[]{CookingRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.CUTTING_BOARD.get()), new ResourceLocation[]{CuttingRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.STOVE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CAMPFIRE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.SKILLET.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CAMPFIRE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ORGANIC_COMPOST.get()), new ResourceLocation[]{DecompositionRecipeCategory.UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CookingPotScreen.class, 89, 25, 24, 17, new ResourceLocation[]{CookingRecipeCategory.UID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CookingPotContainer.class, CookingRecipeCategory.UID, 0, 6, 9, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

