/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.crafting.ingredients.ChanceResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CuttingBoardRecipeBuilder {
    private final List<ChanceResult> results = new ArrayList<ChanceResult>(4);
    private final Ingredient ingredient;
    private final Ingredient tool;
    private String soundEventID;

    private CuttingBoardRecipeBuilder(Ingredient ingredient, Ingredient tool, IItemProvider mainResult, int count, float chance) {
        this.results.add(new ChanceResult(new ItemStack((IItemProvider)mainResult.func_199767_j(), count), chance));
        this.ingredient = ingredient;
        this.tool = tool;
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, IItemProvider mainResult, int count) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, count, 1.0f);
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, IItemProvider mainResult, int count, int chance) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, count, chance);
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, IItemProvider mainResult) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, 1, 1.0f);
    }

    public CuttingBoardRecipeBuilder addResult(IItemProvider result) {
        return this.addResult(result, 1);
    }

    public CuttingBoardRecipeBuilder addResult(IItemProvider result, int count) {
        this.results.add(new ChanceResult(new ItemStack((IItemProvider)result.func_199767_j(), count), 1.0f));
        return this;
    }

    public CuttingBoardRecipeBuilder addResultWithChance(IItemProvider result, float chance) {
        return this.addResultWithChance(result, chance, 1);
    }

    public CuttingBoardRecipeBuilder addResultWithChance(IItemProvider result, float chance, int count) {
        this.results.add(new ChanceResult(new ItemStack((IItemProvider)result.func_199767_j(), count), chance));
        return this;
    }

    public CuttingBoardRecipeBuilder addSound(String soundEventID) {
        this.soundEventID = soundEventID;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.ingredient.func_193365_a()[0].func_77973_b());
        this.build(consumerIn, "farmersdelight:cutting/" + location.func_110623_a());
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.ingredient.func_193365_a()[0].func_77973_b());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Cutting Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.ingredient, this.tool, this.results, this.soundEventID == null ? "" : this.soundEventID));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Ingredient tool;
        private final List<ChanceResult> results;
        private final String soundEventID;

        public Result(ResourceLocation idIn, Ingredient ingredientIn, Ingredient toolIn, List<ChanceResult> resultsIn, String soundEventIDIn) {
            this.id = idIn;
            this.ingredient = ingredientIn;
            this.tool = toolIn;
            this.results = resultsIn;
            this.soundEventID = soundEventIDIn;
        }

        public void func_218610_a(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            arrayIngredients.add(this.ingredient.func_200304_c());
            json.add("ingredients", (JsonElement)arrayIngredients);
            json.add("tool", this.tool.func_200304_c());
            JsonArray arrayResults = new JsonArray();
            for (ChanceResult result : this.results) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)result.getStack().func_77973_b()).toString());
                if (result.getStack().func_190916_E() > 1) {
                    jsonobject.addProperty("count", (Number)result.getStack().func_190916_E());
                }
                if (result.getChance() < 1.0f) {
                    jsonobject.addProperty("chance", (Number)Float.valueOf(result.getChance()));
                }
                arrayResults.add((JsonElement)jsonobject);
            }
            json.add("result", (JsonElement)arrayResults);
            if (!this.soundEventID.isEmpty()) {
                json.addProperty("sound", this.soundEventID);
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return CuttingBoardRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

