/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.ConsumeItemTrigger;
import net.minecraft.advancements.criterion.DamagePredicate;
import net.minecraft.advancements.criterion.DamageSourcePredicate;
import net.minecraft.advancements.criterion.EffectsChangedTrigger;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.MobEffectsPredicate;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.advancements.criterion.PlayerHurtEntityTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.potion.Effect;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.advancement.CuttingBoardTrigger;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModEffects;
import vectorwing.farmersdelight.registry.ModEntityTypes;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.utils.TextUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Advancements
extends AdvancementProvider {
    private final Path PATH;
    public static final Logger LOGGER = LogManager.getLogger();

    public Advancements(DataGenerator generatorIn) {
        super(generatorIn);
        this.PATH = generatorIn.func_200391_b();
    }

    public void func_200398_a(DirectoryCache cache) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path1 = Advancements.getPath(this.PATH, advancement);
            try {
                IDataProvider.func_218426_a((Gson)new GsonBuilder().setPrettyPrinting().create(), (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new FarmersDelightAdvancements().accept(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public static class FarmersDelightAdvancements
    implements Consumer<Consumer<Advancement>> {
        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement farmersDelight = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)ModItems.COOKING_POT.get(), (ITextComponent)TextUtils.getTranslation("advancement.root", new Object[0]), (ITextComponent)TextUtils.getTranslation("advancement.root.desc", new Object[0]), new ResourceLocation("minecraft:textures/block/bricks.png"), FrameType.TASK, false, false, false).func_200275_a("seeds", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[0])).func_203904_a(consumer, this.getNameId("main/root"));
            Advancement huntAndGather = FarmersDelightAdvancements.getAdvancement(farmersDelight, (IItemProvider)ModItems.FLINT_KNIFE.get(), "craft_knife", FrameType.TASK, true, true, false).func_200275_a("flint_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.FLINT_KNIFE.get()})).func_200275_a("iron_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.IRON_KNIFE.get()})).func_200275_a("diamond_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.DIAMOND_KNIFE.get()})).func_200275_a("golden_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.GOLDEN_KNIFE.get()})).func_200275_a("netherite_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.NETHERITE_KNIFE.get()})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getNameId("main/craft_knife"));
            Advancement graspingAtStraws = FarmersDelightAdvancements.getAdvancement(huntAndGather, (IItemProvider)ModItems.STRAW.get(), "harvest_straw", FrameType.TASK, true, false, false).func_200275_a("harvest_straw", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.STRAW.get()})).func_203904_a(consumer, this.getNameId("main/harvest_straw"));
            Advancement advancedComposting = FarmersDelightAdvancements.getAdvancement(graspingAtStraws, (IItemProvider)ModItems.ORGANIC_COMPOST.get(), "place_organic_compost", FrameType.TASK, true, false, false).func_200275_a("place_organic_compost", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.ORGANIC_COMPOST.get()))).func_203904_a(consumer, this.getNameId("main/place_organic_compost"));
            Advancement plantFood = FarmersDelightAdvancements.getAdvancement(advancedComposting, (IItemProvider)ModItems.RICH_SOIL.get(), "get_rich_soil", FrameType.GOAL, true, true, false).func_200275_a("get_rich_soil", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.RICH_SOIL.get()})).func_203904_a(consumer, this.getNameId("main/get_rich_soil"));
            Advancement wildButcher = FarmersDelightAdvancements.getAdvancement(huntAndGather, (IItemProvider)ModItems.HAM.get(), "get_ham", FrameType.TASK, true, false, false).func_200275_a("ham", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.HAM.get()})).func_200275_a("smoked_ham", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.SMOKED_HAM.get()})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getNameId("main/get_ham"));
            Advancement watchYourFingers = FarmersDelightAdvancements.getAdvancement(huntAndGather, (IItemProvider)ModItems.CUTTING_BOARD.get(), "use_cutting_board", FrameType.TASK, true, false, false).func_200275_a("cutting_board", (ICriterionInstance)CuttingBoardTrigger.Instance.simple()).func_203904_a(consumer, this.getNameId("main/use_cutting_board"));
            Advancement cantTakeTheHeat = FarmersDelightAdvancements.getAdvancement(watchYourFingers, (IItemProvider)ModItems.NETHERITE_KNIFE.get(), "obtain_netherite_knife", FrameType.CHALLENGE, true, true, false).func_200275_a("obtain_netherite_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.NETHERITE_KNIFE.get()})).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)200)).func_203904_a(consumer, this.getNameId("main/obtain_netherite_knife"));
            Advancement cropsOfTheWild = FarmersDelightAdvancements.getAdvancement(farmersDelight, (IItemProvider)ModItems.WILD_ONIONS.get(), "get_fd_seed", FrameType.TASK, true, true, false).func_200275_a("cabbage_seeds", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.CABBAGE_SEEDS.get()})).func_200275_a("tomato_seeds", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.TOMATO_SEEDS.get()})).func_200275_a("onion", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.ONION.get()})).func_200275_a("rice", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.RICE.get()})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getNameId("main/get_fd_seed"));
            Advancement fungusAmongUs = FarmersDelightAdvancements.getAdvancement(cropsOfTheWild, (IItemProvider)ModItems.RED_MUSHROOM_COLONY.get(), "get_mushroom_colony", FrameType.TASK, true, false, false).func_200275_a("brown_mushroom_colony", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BROWN_MUSHROOM_COLONY.get()})).func_200275_a("red_mushroom_colony", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.RED_MUSHROOM_COLONY.get()})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getNameId("main/get_mushroom_colony"));
            Advancement dippingYourRoots = FarmersDelightAdvancements.getAdvancement(cropsOfTheWild, (IItemProvider)ModItems.RICE.get(), "plant_rice", FrameType.TASK, true, false, false).func_200275_a("plant_rice", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.RICE_CROP.get()))).func_203904_a(consumer, this.getNameId("main/plant_rice"));
            Advancement booHiss = FarmersDelightAdvancements.getAdvancement(cropsOfTheWild, (IItemProvider)ModItems.ROTTEN_TOMATO.get(), "hit_raider_with_rotten_tomato", FrameType.TASK, true, false, false).func_200275_a("hit_raider_with_rotten_tomato", (ICriterionInstance)new PlayerHurtEntityTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, DamagePredicate.Builder.func_203971_a().func_203969_a(DamageSourcePredicate.Builder.func_203981_a().func_203978_a(Boolean.valueOf(true)).func_203980_a(EntityPredicate.Builder.func_203996_a().func_203998_a((EntityType)ModEntityTypes.ROTTEN_TOMATO.get()))).func_203970_b(), EntityPredicate.AndPredicate.func_234585_a_((EntityPredicate)EntityPredicate.Builder.func_203996_a().func_217989_a((ITag)EntityTypeTags.field_219765_b).func_204000_b()))).func_203904_a(consumer, this.getNameId("main/hit_raider_with_rotten_tomato"));
            Advancement cropRotation = FarmersDelightAdvancements.getAdvancement(dippingYourRoots, (IItemProvider)ModItems.CABBAGE.get(), "plant_all_crops", FrameType.CHALLENGE, true, true, false).func_200275_a("wheat", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150464_aj)).func_200275_a("beetroot", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_185773_cZ)).func_200275_a("carrot", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150459_bM)).func_200275_a("potato", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150469_bN)).func_200275_a("cabbage", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.CABBAGE_CROP.get()))).func_200275_a("tomato", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.TOMATO_CROP.get()))).func_200275_a("onion", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.ONION_CROP.get()))).func_200275_a("rice", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.RICE_CROP.get()))).func_200275_a("melon", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150394_bc)).func_200275_a("pumpkin", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150393_bb)).func_200275_a("sweet_berries", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_222434_lW)).func_200275_a("sugar_cane", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_196608_cF)).func_200275_a("cocoa", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150375_by)).func_200275_a("nether_wart", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150388_bm)).func_200275_a("chorus_flower", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_185766_cS)).func_200275_a("brown_mushroom", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150338_P)).func_200275_a("red_mushroom", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_150337_Q)).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)100)).func_203904_a(consumer, this.getNameId("main/plant_all_crops"));
            Advancement bonfireLit = FarmersDelightAdvancements.getAdvancement(farmersDelight, (IItemProvider)Blocks.field_222433_lV, "place_campfire", FrameType.TASK, true, true, false).func_200275_a("campfire", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_222433_lV)).func_200275_a("soul_campfire", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_235367_mf_)).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getNameId("main/place_campfire"));
            Advancement portableCooking = FarmersDelightAdvancements.getAdvancement(bonfireLit, (IItemProvider)ModItems.SKILLET.get(), "use_skillet", FrameType.TASK, true, false, false).func_200275_a("skillet", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.SKILLET.get()))).func_203904_a(consumer, this.getNameId("main/use_skillet"));
            Advancement sizzlingHot = FarmersDelightAdvancements.getAdvancement(portableCooking, (IItemProvider)ModItems.SKILLET.get(), "place_skillet", FrameType.TASK, true, false, false).func_200275_a("skillet", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.SKILLET.get()))).func_203904_a(consumer, this.getNameId("main/place_skillet"));
            Advancement dinnerIsServed = FarmersDelightAdvancements.getAdvancement(bonfireLit, (IItemProvider)ModItems.COOKING_POT.get(), "place_cooking_pot", FrameType.GOAL, true, true, false).func_200275_a("cooking_pot", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.COOKING_POT.get()))).func_203904_a(consumer, this.getNameId("main/place_cooking_pot"));
            Advancement comforting = FarmersDelightAdvancements.getAdvancement(dinnerIsServed, (IItemProvider)ModItems.BAKED_COD_STEW.get(), "eat_comfort_food", FrameType.TASK, true, false, false).func_200275_a("comfort", (ICriterionInstance)EffectsChangedTrigger.Instance.func_203917_a((MobEffectsPredicate)MobEffectsPredicate.func_204014_a().func_204015_a((Effect)ModEffects.COMFORT.get()))).func_203904_a(consumer, this.getNameId("main/eat_comfort_food"));
            Advancement nourishing = FarmersDelightAdvancements.getAdvancement(comforting, (IItemProvider)ModItems.STEAK_AND_POTATOES.get(), "eat_nourishing_food", FrameType.TASK, true, false, false).func_200275_a("nourishment", (ICriterionInstance)EffectsChangedTrigger.Instance.func_203917_a((MobEffectsPredicate)MobEffectsPredicate.func_204014_a().func_204015_a((Effect)ModEffects.NOURISHED.get()))).func_203904_a(consumer, this.getNameId("main/eat_nourishing_food"));
            Advancement gloriousFeast = FarmersDelightAdvancements.getAdvancement(nourishing, (IItemProvider)ModItems.ROAST_CHICKEN_BLOCK.get(), "place_feast", FrameType.TASK, true, true, false).func_200275_a("roast_chicken", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.ROAST_CHICKEN_BLOCK.get()))).func_200275_a("stuffed_pumpkin", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.STUFFED_PUMPKIN_BLOCK.get()))).func_200275_a("honey_glazed_ham", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.HONEY_GLAZED_HAM_BLOCK.get()))).func_200275_a("shepherds_pie", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.SHEPHERDS_PIE_BLOCK.get()))).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getNameId("main/place_feast"));
            Advancement masterChef = FarmersDelightAdvancements.getAdvancement(gloriousFeast, (IItemProvider)ModItems.HONEY_GLAZED_HAM.get(), "master_chef", FrameType.CHALLENGE, true, true, false).func_200275_a("mixed_salad", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.MIXED_SALAD.get()))).func_200275_a("beef_stew", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.BEEF_STEW.get()))).func_200275_a("chicken_soup", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.CHICKEN_SOUP.get()))).func_200275_a("vegetable_soup", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.VEGETABLE_SOUP.get()))).func_200275_a("fish_stew", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.FISH_STEW.get()))).func_200275_a("fried_rice", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.FRIED_RICE.get()))).func_200275_a("pumpkin_soup", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.PUMPKIN_SOUP.get()))).func_200275_a("baked_cod_stew", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.BAKED_COD_STEW.get()))).func_200275_a("noodle_soup", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.NOODLE_SOUP.get()))).func_200275_a("pasta_with_meatballs", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.PASTA_WITH_MEATBALLS.get()))).func_200275_a("pasta_with_mutton_chop", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.PASTA_WITH_MUTTON_CHOP.get()))).func_200275_a("roasted_mutton_chops", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.ROASTED_MUTTON_CHOPS.get()))).func_200275_a("vegetable_noodles", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.VEGETABLE_NOODLES.get()))).func_200275_a("steak_and_potatoes", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.STEAK_AND_POTATOES.get()))).func_200275_a("ratatouille", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.RATATOUILLE.get()))).func_200275_a("squid_ink_pasta", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.SQUID_INK_PASTA.get()))).func_200275_a("grilled_salmon", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.GRILLED_SALMON.get()))).func_200275_a("roast_chicken", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.ROAST_CHICKEN.get()))).func_200275_a("stuffed_pumpkin", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.STUFFED_PUMPKIN.get()))).func_200275_a("honey_glazed_ham", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.HONEY_GLAZED_HAM.get()))).func_200275_a("shepherds_pie", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.SHEPHERDS_PIE.get()))).func_200275_a("bacon_and_eggs", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.BACON_AND_EGGS.get()))).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)200)).func_203904_a(consumer, this.getNameId("main/master_chef"));
        }

        protected static Advancement.Builder getAdvancement(Advancement parent, IItemProvider display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a(display, (ITextComponent)TextUtils.getTranslation("advancement." + name, new Object[0]), (ITextComponent)TextUtils.getTranslation("advancement." + name + ".desc", new Object[0]), null, frame, showToast, announceToChat, hidden);
        }

        private String getNameId(String id) {
            return "farmersdelight:" + id;
        }
    }
}

