/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.item;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vectorwing.farmersdelight.client.item.WrappedItemModel;

public class SkilletModel
implements IBakedModel {
    private final ModelBakery bakery;
    private final IBakedModel originalModel;
    private final IBakedModel cookingModel;
    private final ItemOverrideList itemOverrides = new ItemOverrideList(){

        @Nonnull
        public IBakedModel func_239290_a_(@Nonnull IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            CompoundNBT tag = stack.func_196082_o();
            if (tag.func_74764_b("Cooking")) {
                ItemStack ingredientStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Cooking"));
                return SkilletModel.this.getCookingModel(ingredientStack);
            }
            return SkilletModel.this.originalModel;
        }
    };
    private final HashMap<Item, CompositeBakedModel> cache = new HashMap();

    public SkilletModel(ModelBakery bakery, IBakedModel originalModel, IBakedModel cookingModel) {
        this.bakery = bakery;
        this.originalModel = (IBakedModel)Preconditions.checkNotNull((Object)originalModel);
        this.cookingModel = (IBakedModel)Preconditions.checkNotNull((Object)cookingModel);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.itemOverrides;
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.originalModel.func_200117_a(state, side, rand);
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.originalModel.func_177552_f();
    }

    public boolean func_177555_b() {
        return this.originalModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalModel.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.originalModel.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.originalModel.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.originalModel.func_177554_e();
    }

    private CompositeBakedModel getCookingModel(ItemStack ingredientStack) {
        return this.cache.computeIfAbsent(ingredientStack.func_77973_b(), p -> new CompositeBakedModel(this.bakery, ingredientStack, this.cookingModel));
    }

    private static class CompositeBakedModel
    extends WrappedItemModel<IBakedModel> {
        private final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

        public CompositeBakedModel(ModelBakery bakery, ItemStack ingredientStack, IBakedModel skillet) {
            super(skillet);
            IBakedModel ingredientBaked;
            ResourceLocation ingredientLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)ingredientStack.func_77973_b());
            IUnbakedModel ingredientUnbaked = bakery.func_209597_a((ResourceLocation)new ModelResourceLocation(ingredientLocation, "inventory"));
            SimpleModelTransform transform = new SimpleModelTransform(new TransformationMatrix(new Vector3f(0.0f, -0.4f, 0.0f), Vector3f.field_229179_b_.func_229187_a_(270.0f), new Vector3f(0.625f, 0.625f, 0.625f), null));
            ResourceLocation name = new ResourceLocation("farmersdelight", "skillet_with_" + ingredientLocation.toString().replace(':', '_'));
            if (ingredientUnbaked instanceof BlockModel && ((BlockModel)ingredientUnbaked).func_178310_f() == ModelBakery.field_177606_o) {
                Direction[] bm = (Direction[])ingredientUnbaked;
                ingredientBaked = new ItemModelGenerator().func_209579_a(ModelLoader.defaultTextureGetter(), (BlockModel)bm).func_228813_a_(bakery, (BlockModel)bm, ModelLoader.defaultTextureGetter(), (IModelTransform)transform, name, false);
            } else {
                ingredientBaked = ingredientUnbaked.func_225613_a_(bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)transform, name);
            }
            for (Direction e : Direction.values()) {
                this.faceQuads.put(e, new ArrayList());
            }
            Random rand = new Random(0L);
            this.genQuads.addAll(ingredientBaked.func_200117_a(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(ingredientBaked.func_200117_a(null, e, rand));
            }
            rand.setSeed(0L);
            this.genQuads.addAll(skillet.func_200117_a(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(skillet.func_200117_a(null, e, rand));
            }
        }

        @Override
        public boolean func_188618_c() {
            return this.originalModel.func_188618_c();
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(BlockState state, Direction face, @Nonnull Random rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }

        @Override
        public IBakedModel handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType, MatrixStack stack) {
            super.handlePerspective(cameraTransformType, stack);
            return this;
        }
    }
}

