/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.soulsandlife.init;

import com.lclc98.soulsandlife.entity.monster.EntitySoulSandBall;
import com.lclc98.soulsandlife.entity.monster.EntitySoulSandMob;
import com.lclc98.soulsandlife.init.SoulSandArmorMaterial;
import com.lclc98.soulsandlife.init.SoulSandItemTier;
import com.lclc98.soulsandlife.item.ItemSoulSandArmor;
import com.lclc98.soulsandlife.item.ItemSoulSandEdible;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.SwordItem;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoulSandLifeRegistry {
    public static final IItemTier SOUL_SAND_TOOL_MATERIAL = new SoulSandItemTier();
    public static final IArmorMaterial SOUL_SAND_ARMOR_MATERIAL = new SoulSandArmorMaterial();
    public static final EntityType<EntitySoulSandMob> ENTITY_TYPE_SOUL_SAND_MOB = EntityType.Builder.func_220322_a(EntitySoulSandMob::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.1f, 1.2f).setTrackingRange(80).func_220320_c().func_206830_a("soul_sand_monster");
    public static final EntityType<EntitySoulSandBall> ENTITY_TYPE_SOUL_SAND_BALL = EntityType.Builder.func_220322_a(EntitySoulSandBall::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setTrackingRange(4).func_233606_a_(10).setCustomClientFactory(EntitySoulSandBall::new).func_206830_a("soul_sand_ball");
    public static final Item SOUL_SAND_EDIBLE = new ItemSoulSandEdible();
    public static final Item SOUL_SAND_SWORD = (Item)new SwordItem(SOUL_SAND_TOOL_MATERIAL, 3, -2.4f, new Item.Properties().func_200916_a(ItemGroup.field_78037_j)).setRegistryName("soulsandlife", "soul_sand_sword");
    public static final Item SOUL_SAND_HELMET = new ItemSoulSandArmor(EquipmentSlotType.HEAD);
    public static final Item SOUL_SAND_CHEST = new ItemSoulSandArmor(EquipmentSlotType.CHEST);
    public static final Item SOUL_SAND_LEGS = new ItemSoulSandArmor(EquipmentSlotType.LEGS);
    public static final Item SOUL_SAND_FEET = new ItemSoulSandArmor(EquipmentSlotType.FEET);

    @SubscribeEvent
    public static void registerEntity(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)((EntityType)ENTITY_TYPE_SOUL_SAND_MOB.setRegistryName("soulsandlife", "soul_sand_monster")));
        event.getRegistry().register((IForgeRegistryEntry)((EntityType)ENTITY_TYPE_SOUL_SAND_BALL.setRegistryName("soulsandlife", "soul_sand_ball")));
        EntitySpawnPlacementRegistry.func_209343_a(ENTITY_TYPE_SOUL_SAND_MOB, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySoulSandMob::canSpawn);
    }

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put(ENTITY_TYPE_SOUL_SAND_MOB, EntitySoulSandMob.getSoulSandAttributes().func_233813_a_());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)SOUL_SAND_SWORD);
        event.getRegistry().register((IForgeRegistryEntry)SOUL_SAND_HELMET);
        event.getRegistry().register((IForgeRegistryEntry)SOUL_SAND_CHEST);
        event.getRegistry().register((IForgeRegistryEntry)SOUL_SAND_LEGS);
        event.getRegistry().register((IForgeRegistryEntry)SOUL_SAND_FEET);
        event.getRegistry().register((IForgeRegistryEntry)SOUL_SAND_EDIBLE);
        event.getRegistry().register((IForgeRegistryEntry)((Item)new SpawnEggItem(ENTITY_TYPE_SOUL_SAND_MOB, 9536340, 6905143, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("soulsandlife", "soul_sand_monster_spawn_egg")));
    }
}

