/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.soulsandlife.entity.monster;

import com.lclc98.soulsandlife.entity.monster.EntitySoulSandBall;
import com.lclc98.soulsandlife.init.SoulSandLifeRegistry;
import com.lclc98.soulsandlife.item.ItemSoulSandEdible;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class EntitySoulSandMob
extends TameableEntity {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;

    public EntitySoulSandMob(EntityType<EntitySoulSandMob> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.func_110138_aP();
        this.field_70728_aV = 10;
        this.func_174805_g(this.func_70909_n());
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, false, entity -> entity != null && !(entity.func_184614_ca().func_77973_b() instanceof ItemSoulSandEdible)));
    }

    public static AttributeModifierMap.MutableAttribute getSoulSandAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                if (this.func_70909_n()) continue;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        LivingEntity livingentity;
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((livingentity = this.func_70638_az()) != null) {
            if (livingentity.func_184614_ca().func_77973_b() instanceof ItemSoulSandEdible) {
                this.func_70624_b(null);
            }
            if (livingentity.func_226280_cw_() > this.func_226280_cw_() + (double)this.heightOffset && this.func_213336_c(livingentity)) {
                Vector3d vector3d = this.func_213322_ci();
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vector3d.field_72448_b) * (double)0.3f, 0.0));
                this.field_70160_al = true;
            }
        }
        super.func_70619_bc();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public static boolean canSpawn(EntityType<? extends EntitySoulSandMob> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return spawnReason == SpawnReason.SPAWNER || world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_233687_w_(false);
        return super.func_70097_a(source, amount);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(20.0f);
            this.func_174805_g(true);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(15.0);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            Item food;
            if (stack.func_77973_b() instanceof ItemSoulSandEdible && (food = stack.func_77973_b()).func_219971_r() && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.func_70691_i(food.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            ActionResultType actionresulttype = super.func_230254_b_(player, hand);
            if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)player)) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                return ActionResultType.SUCCESS;
            }
            return actionresulttype;
        }
        if (stack.func_77973_b() == SoulSandLifeRegistry.SOUL_SAND_EDIBLE) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return false;
    }

    static class AIFireballAttack
    extends Goal {
        private final EntitySoulSandMob soulSandMob;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public AIFireballAttack(EntitySoulSandMob soulSandMob) {
            this.soulSandMob = soulSandMob;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.soulSandMob.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.soulSandMob.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.lastSeen = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingentity = this.soulSandMob.func_70638_az();
            if (livingentity != null) {
                boolean flag = this.soulSandMob.func_70635_at().func_75522_a((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.soulSandMob.func_70068_e((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.soulSandMob.func_70652_k((Entity)livingentity);
                    }
                    this.soulSandMob.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.func_226277_ct_() - this.soulSandMob.func_226277_ct_();
                    double d2 = livingentity.func_226283_e_(0.5) - this.soulSandMob.func_226283_e_(0.5);
                    double d3 = livingentity.func_226281_cx_() - this.soulSandMob.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 10;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 50;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            if (!this.soulSandMob.func_174814_R()) {
                                this.soulSandMob.field_70170_p.func_217378_a(null, 1018, this.soulSandMob.func_233580_cy_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                EntitySoulSandBall soulSandBall = new EntitySoulSandBall(this.soulSandMob.field_70170_p, (LivingEntity)this.soulSandMob, d1 + this.soulSandMob.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.soulSandMob.func_70681_au().nextGaussian() * (double)f);
                                soulSandBall.func_70107_b(soulSandBall.func_226277_ct_(), this.soulSandMob.func_226283_e_(0.5) + 0.5, soulSandBall.func_226281_cx_());
                                this.soulSandMob.field_70170_p.func_217376_c((Entity)soulSandBall);
                            }
                        }
                    }
                    this.soulSandMob.func_70671_ap().func_75651_a((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.soulSandMob.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.soulSandMob.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

