/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.enchantment;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/enchantment/EnchantmentType")
@NativeTypeRegistration(value=EnchantmentType.class, zenCodeName="crafttweaker.api.enchantment.EnchantmentType")
public class ExpandEnchantmentType {
    @ZenCodeType.Method
    public static boolean canEnchantItem(EnchantmentType internal, Item itemIn) {
        return internal.func_77557_a(itemIn);
    }

    @ZenCodeType.Method
    public static List<Enchantment> getEnchantments(EnchantmentType internal) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            if (internal != enchantment.field_77351_y) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    @ZenCodeType.Method
    public static List<Item> getItems(EnchantmentType internal) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!internal.func_77557_a(item)) continue;
            items.add(item);
        }
        return items;
    }

    @ZenCodeType.StaticExpansionMethod
    public static List<EnchantmentType> getTypesForItem(Item item) {
        ArrayList<EnchantmentType> validTypes = new ArrayList<EnchantmentType>();
        for (EnchantmentType type : EnchantmentType.values()) {
            if (!type.func_77557_a(item)) continue;
            validTypes.add(type);
        }
        return validTypes;
    }

    @ZenCodeType.StaticExpansionMethod
    public static EnchantmentType create(String name, Predicate<Item> canEnchantPredicate) {
        return EnchantmentType.create((String)name, canEnchantPredicate);
    }
}

