/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.enchantment;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/enchantment/MCEnchantment")
@NativeTypeRegistration(value=Enchantment.class, zenCodeName="crafttweaker.api.enchantment.MCEnchantment")
public class ExpandEnchantment {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="rarity")
    public static Enchantment.Rarity getRarity(Enchantment internal) {
        return internal.func_77324_c();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="type")
    public static EnchantmentType getType(Enchantment internal) {
        return internal.field_77351_y;
    }

    @ZenCodeType.Method
    public static Map<EquipmentSlotType, IItemStack> getEntityEquipment(Enchantment internal, LivingEntity livingEntity) {
        return internal.func_222181_a(livingEntity).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> new MCItemStack((ItemStack)o.getValue())));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="minLevel")
    public static int getMinLevel(Enchantment internal) {
        return internal.func_77319_d();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="maxLevel")
    public static int getMaxLevel(Enchantment internal) {
        return internal.func_77325_b();
    }

    @ZenCodeType.Method
    public static int getMinEnchantability(Enchantment internal, int enchantmentLevel) {
        return internal.func_77321_a(enchantmentLevel);
    }

    @ZenCodeType.Method
    public static int getMaxEnchantability(Enchantment internal, int enchantmentLevel) {
        return internal.func_223551_b(enchantmentLevel);
    }

    @ZenCodeType.Method
    public static boolean isCompatibleWith(Enchantment internal, Enchantment other) {
        return internal.func_191560_c(other);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="name")
    public static String getName(Enchantment internal) {
        return internal.func_77320_a();
    }

    @ZenCodeType.Method
    public static MCTextComponent getDisplayName(Enchantment internal, int level) {
        return new MCTextComponent(internal.func_200305_d(level));
    }

    @ZenCodeType.Method
    public static boolean canApply(Enchantment internal, IItemStack stack) {
        return internal.func_92089_a(stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="treasure")
    public static boolean isTreasureEnchantment(Enchantment internal) {
        return internal.func_185261_e();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="curse")
    public static boolean isCurse(Enchantment internal) {
        return internal.func_190936_d();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canVillagerTrade")
    public static boolean canVillagerTrade(Enchantment internal) {
        return internal.func_230309_h_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canGenerateInLoot")
    public static boolean canGenerateInLoot(Enchantment internal) {
        return internal.func_230310_i_();
    }

    @ZenCodeType.Method
    public static boolean canApplyAtEnchantingTable(Enchantment internal, ItemStack stack) {
        return internal.canApplyAtEnchantingTable(stack);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allowedOnBook")
    public static boolean isAllowedOnBooks(Enchantment internal) {
        return internal.isAllowedOnBooks();
    }
}

