/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagAdd;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagCreate;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagRemove;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.tags.TagRegistry;
import net.minecraft.tags.TagRegistryManager;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class TagManagerWrapper<T>
implements TagManager<T> {
    @Nonnull
    private final Class<T> elementClass;
    @Nonnull
    private final ResourceLocation tagTypeName;
    @Nonnull
    private final String tagFolder;

    public TagManagerWrapper(Class<T> elementClass, ResourceLocation tagTypeName, String tagFolder) {
        this.elementClass = elementClass;
        this.tagTypeName = tagTypeName;
        this.tagFolder = tagFolder;
    }

    @Override
    @Nonnull
    public Class<T> getElementClass() {
        return this.elementClass;
    }

    @Override
    public ITagCollection<?> getTagCollection() {
        Map customTagTypes = TagCollectionManager.func_242178_a().getCustomTagTypes();
        if (customTagTypes.containsKey(this.tagTypeName)) {
            return (ITagCollection)customTagTypes.get(this.tagTypeName);
        }
        if (TagRegistryManager.field_242190_a.containsKey(this.tagTypeName)) {
            CraftTweakerAPI.logDebug("Falling back to TagRegistryManager for collection '" + this.tagTypeName + '\'', new Object[0]);
            return ((TagRegistry)TagRegistryManager.field_242190_a.get(this.tagTypeName)).func_232939_b_();
        }
        throw new IllegalArgumentException("Could not find TagCollection for '" + this.tagTypeName + '\'');
    }

    @Override
    @Nonnull
    public String getTagFolder() {
        return this.tagFolder;
    }

    @Override
    public List<MCTag<T>> getAllTagsFor(T element) {
        ITagCollection<?> tagCollection = this.getTagCollection();
        Collection owningTags = tagCollection.func_199913_a(element);
        return owningTags.stream().map(location -> new MCTag((ResourceLocation)location, this)).collect(Collectors.toList());
    }

    @Override
    public void addElements(MCTag<T> to, List<T> toAdd) {
        ITag<?> internal = this.getInternal(to);
        if (internal == null) {
            Tag tagFromContents = new Tag((Set)Sets.newHashSet(toAdd), this.getElementClass());
            CraftTweakerAPI.apply(new ActionTagCreate(this.getTagCollection(), (ITag<?>)tagFromContents, to));
        } else {
            CraftTweakerAPI.apply(new ActionTagAdd(internal, toAdd, to));
        }
    }

    @Override
    public void removeElements(MCTag<T> from, List<T> toRemove) {
        ITag<?> internal = this.getInternal(from);
        if (internal == null) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionTagRemove(internal, toRemove, from));
    }

    @Override
    public List<T> getElementsInTag(MCTag<T> theTag) {
        ITag<?> internal = this.getInternal(theTag);
        if (internal == null) {
            return Collections.emptyList();
        }
        return internal.func_230236_b_();
    }
}

