/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.DistancePredicate;
import com.blamejared.crafttweaker.impl.predicate.EffectData;
import com.blamejared.crafttweaker.impl.predicate.EntityEquipmentPredicate;
import com.blamejared.crafttweaker.impl.predicate.EntityFlagsPredicate;
import com.blamejared.crafttweaker.impl.predicate.EntityTypePredicate;
import com.blamejared.crafttweaker.impl.predicate.FishingPredicate;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.LocationPredicate;
import com.blamejared.crafttweaker.impl.predicate.MobEffectsPredicate;
import com.blamejared.crafttweaker.impl.predicate.NBTPredicate;
import com.blamejared.crafttweaker.impl.predicate.PlayerPredicate;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.EntityPredicate")
@Document(value="vanilla/api/predicate/EntityPredicate")
public final class EntityPredicate
extends IVanillaWrappingPredicate.AnyDefaulting<net.minecraft.advancements.criterion.EntityPredicate> {
    private EntityTypePredicate entityTypePredicate = new EntityTypePredicate();
    private DistancePredicate distancePredicate = new DistancePredicate();
    private LocationPredicate locationPredicate = new LocationPredicate();
    private MobEffectsPredicate effectsPredicate = new MobEffectsPredicate();
    private NBTPredicate nbtPredicate = new NBTPredicate();
    private EntityFlagsPredicate entityFlagsPredicate = new EntityFlagsPredicate();
    private EntityEquipmentPredicate equipmentPredicate = new EntityEquipmentPredicate();
    private PlayerPredicate player = new PlayerPredicate();
    private FishingPredicate fishing = new FishingPredicate();
    private EntityPredicate riddenEntity;
    private EntityPredicate targetedEntity;
    private String team;
    private ResourceLocation catType;

    public EntityPredicate() {
        super(net.minecraft.advancements.criterion.EntityPredicate.field_192483_a);
    }

    @ZenCodeType.Method
    public EntityPredicate withEntityTypePredicate(Consumer<EntityTypePredicate> builder) {
        EntityTypePredicate predicate = new EntityTypePredicate();
        builder.accept(predicate);
        this.entityTypePredicate = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withDistancePredicate(Consumer<DistancePredicate> builder) {
        DistancePredicate predicate = new DistancePredicate();
        builder.accept(predicate);
        this.distancePredicate = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withLocationPredicate(Consumer<LocationPredicate> builder) {
        LocationPredicate predicate = new LocationPredicate();
        builder.accept(predicate);
        this.locationPredicate = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withEffectPredicate(Consumer<MobEffectsPredicate> builder) {
        MobEffectsPredicate predicate = new MobEffectsPredicate();
        builder.accept(predicate);
        this.effectsPredicate = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withEffectPredicate(Effect effect, Consumer<EffectData> builder) {
        return this.withEffectPredicate(predicate -> predicate.withEffect(effect, builder));
    }

    @ZenCodeType.Method
    public EntityPredicate withDataPredicate(Consumer<NBTPredicate> builder) {
        NBTPredicate predicate = new NBTPredicate();
        builder.accept(predicate);
        this.nbtPredicate = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withFlagsPredicate(Consumer<EntityFlagsPredicate> builder) {
        EntityFlagsPredicate predicate = new EntityFlagsPredicate();
        builder.accept(predicate);
        this.entityFlagsPredicate = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withEquipmentPredicate(Consumer<EntityEquipmentPredicate> builder) {
        EntityEquipmentPredicate predicate = new EntityEquipmentPredicate();
        builder.accept(predicate);
        this.equipmentPredicate = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withPlayerPredicate(Consumer<PlayerPredicate> builder) {
        PlayerPredicate predicate = new PlayerPredicate();
        builder.accept(predicate);
        this.player = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withFishingPredicate(Consumer<FishingPredicate> builder) {
        FishingPredicate predicate = new FishingPredicate();
        builder.accept(predicate);
        this.fishing = predicate;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withRiddenEntityPredicate(Consumer<EntityPredicate> builder) {
        EntityPredicate riddenEntity = new EntityPredicate();
        builder.accept(riddenEntity);
        this.riddenEntity = riddenEntity;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withTargetedEntityPredicate(Consumer<EntityPredicate> builder) {
        EntityPredicate targetedEntity = new EntityPredicate();
        builder.accept(targetedEntity);
        this.targetedEntity = targetedEntity;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withTeam(String team) {
        this.team = team;
        return this;
    }

    @ZenCodeType.Method
    public EntityPredicate withCatType(ResourceLocation catType) {
        this.catType = catType;
        return this;
    }

    @Override
    public boolean isAny() {
        return !(!Stream.of(this.entityTypePredicate, this.distancePredicate, this.locationPredicate, this.effectsPredicate, this.nbtPredicate, this.entityFlagsPredicate, this.equipmentPredicate, this.player, this.fishing).allMatch(IVanillaWrappingPredicate.AnyDefaulting::isAny) || this.riddenEntity != null && !this.riddenEntity.isAny() || this.targetedEntity != null && !this.targetedEntity.isAny() || this.team == null || this.catType == null);
    }

    @Override
    public net.minecraft.advancements.criterion.EntityPredicate toVanilla() {
        return EntityPredicate.Builder.func_203996_a().func_209366_a((net.minecraft.advancements.criterion.EntityTypePredicate)this.entityTypePredicate.toVanillaPredicate()).func_203997_a((net.minecraft.advancements.criterion.DistancePredicate)this.distancePredicate.toVanillaPredicate()).func_203999_a((net.minecraft.advancements.criterion.LocationPredicate)this.locationPredicate.toVanillaPredicate()).func_209367_a((net.minecraft.advancements.criterion.MobEffectsPredicate)this.effectsPredicate.toVanillaPredicate()).func_209365_a((net.minecraft.advancements.criterion.NBTPredicate)this.nbtPredicate.toVanillaPredicate()).func_217987_a((net.minecraft.advancements.criterion.EntityFlagsPredicate)this.entityFlagsPredicate.toVanillaPredicate()).func_217985_a((net.minecraft.advancements.criterion.EntityEquipmentPredicate)this.equipmentPredicate.toVanillaPredicate()).func_226613_a_((net.minecraft.advancements.criterion.PlayerPredicate)this.player.toVanillaPredicate()).func_234580_a_((net.minecraft.loot.FishingPredicate)this.fishing.toVanillaPredicate()).func_234579_a_(this.riddenEntity == null ? net.minecraft.advancements.criterion.EntityPredicate.field_192483_a : (net.minecraft.advancements.criterion.EntityPredicate)this.riddenEntity.toVanillaPredicate()).func_234581_b_(this.targetedEntity == null ? net.minecraft.advancements.criterion.EntityPredicate.field_192483_a : (net.minecraft.advancements.criterion.EntityPredicate)this.targetedEntity.toVanillaPredicate()).func_226614_a_(this.team).func_217988_b(this.catType).func_204000_b();
    }
}

