/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.misc;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.villagers.BasicTradeExposer;
import com.blamejared.crafttweaker.api.villagers.CTTradeObject;
import com.blamejared.crafttweaker.api.villagers.ITradeRemover;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionAddTrade;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionAddWanderingTrade;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionRemoveTrade;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionRemoveWanderingTrade;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionTradeBase;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.villagers.VillagerTrades")
@Document(value="vanilla/api/villager/VillagerTrades")
public class CTVillagerTrades {
    @ZenCodeGlobals.Global(value="villagerTrades")
    public static final CTVillagerTrades INSTANCE = new CTVillagerTrades();
    private final List<ActionTradeBase> villagerTradeActions = new ArrayList<ActionTradeBase>();
    private final List<ActionTradeBase> wanderingTradeActions = new ArrayList<ActionTradeBase>();
    private boolean ranEvents = false;
    public static Map<Class<? extends VillagerTrades.ITrade>, Function<VillagerTrades.ITrade, CTTradeObject>> TRADE_CONVERTER = (Map)Util.func_200696_a(new HashMap(), classFunctionMap -> {
        MCItemStackMutable emerald = new MCItemStackMutable(new ItemStack((IItemProvider)Items.field_151166_bC));
        MCItemStackMutable compass = new MCItemStackMutable(new ItemStack((IItemProvider)Items.field_151111_aL));
        MCItemStackMutable book = new MCItemStackMutable(new ItemStack((IItemProvider)Items.field_151122_aG));
        MCItemStackMutable enchantedBook = new MCItemStackMutable(new ItemStack((IItemProvider)Items.field_151134_bR));
        MCItemStackMutable filledMap = new MCItemStackMutable(new ItemStack((IItemProvider)Items.field_151098_aY));
        MCItemStackMutable suspiciousStew = new MCItemStackMutable(new ItemStack((IItemProvider)Items.field_222115_pz));
        classFunctionMap.put(VillagerTrades.DyedArmorForEmeraldsTrade.class, iTrade -> {
            if (iTrade instanceof VillagerTrades.DyedArmorForEmeraldsTrade) {
                return new CTTradeObject(emerald, MCItemStack.EMPTY.get(), new MCItemStackMutable(((VillagerTrades.DyedArmorForEmeraldsTrade)iTrade).field_221233_a.func_190903_i()));
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
        classFunctionMap.put(VillagerTrades.EmeraldForItemsTrade.class, iTrade -> {
            if (iTrade instanceof VillagerTrades.EmeraldForItemsTrade) {
                return new CTTradeObject(new MCItemStackMutable(((VillagerTrades.EmeraldForItemsTrade)iTrade).field_221183_a.func_190903_i()), MCItemStack.EMPTY.get(), emerald);
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
        classFunctionMap.put(VillagerTrades.EmeraldForMapTrade.class, iTrade -> new CTTradeObject(emerald, compass, filledMap));
        classFunctionMap.put(VillagerTrades.EmeraldForVillageTypeItemTrade.class, iTrade -> new CTTradeObject(MCItemStack.EMPTY.get(), MCItemStack.EMPTY.get(), emerald));
        classFunctionMap.put(VillagerTrades.EnchantedBookForEmeraldsTrade.class, iTrade -> new CTTradeObject(emerald, book, enchantedBook));
        classFunctionMap.put(VillagerTrades.EnchantedItemForEmeraldsTrade.class, iTrade -> {
            if (iTrade instanceof VillagerTrades.EnchantedItemForEmeraldsTrade) {
                return new CTTradeObject(emerald, MCItemStack.EMPTY.get(), new MCItemStackMutable(((VillagerTrades.EnchantedItemForEmeraldsTrade)iTrade).field_221195_a));
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
        classFunctionMap.put(VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade.class, iTrade -> {
            if (iTrade instanceof VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade) {
                return new CTTradeObject(emerald, new MCItemStackMutable(((VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade)iTrade).field_221224_f.func_190903_i()), new MCItemStackMutable(((VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade)iTrade).field_221219_a));
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
        classFunctionMap.put(VillagerTrades.ItemsForEmeraldsAndItemsTrade.class, iTrade -> {
            if (iTrade instanceof VillagerTrades.ItemsForEmeraldsAndItemsTrade) {
                return new CTTradeObject(emerald, new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsAndItemsTrade)iTrade).field_221200_a), new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsAndItemsTrade)iTrade).field_221203_d));
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
        classFunctionMap.put(VillagerTrades.ItemsForEmeraldsTrade.class, iTrade -> {
            if (iTrade instanceof VillagerTrades.ItemsForEmeraldsTrade) {
                return new CTTradeObject(emerald, MCItemStack.EMPTY.get(), new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsTrade)iTrade).field_221208_a));
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
        classFunctionMap.put(VillagerTrades.SuspiciousStewForEmeraldTrade.class, iTrade -> new CTTradeObject(emerald, MCItemStack.EMPTY.get(), suspiciousStew));
        classFunctionMap.put(BasicTrade.class, iTrade -> {
            if (iTrade instanceof BasicTrade) {
                return new CTTradeObject(new MCItemStackMutable(BasicTradeExposer.getPrice(iTrade)), new MCItemStackMutable(BasicTradeExposer.getPrice2(iTrade)), new MCItemStackMutable(BasicTradeExposer.getForSale(iTrade)));
            }
            throw new IllegalArgumentException("Invalid trade passed to trade function! Given: " + iTrade.getClass());
        });
    });

    public CTVillagerTrades() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, event -> {
            this.wanderingTradeActions.forEach(IUndoableAction::undo);
            this.wanderingTradeActions.forEach(actionTradeBase -> {
                List trades;
                switch (actionTradeBase.getLevel()) {
                    case 1: {
                        trades = event.getGenericTrades();
                        break;
                    }
                    case 2: {
                        trades = event.getRareTrades();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                actionTradeBase.apply(trades);
            });
            this.wanderingTradeActions.clear();
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, event -> {
            List<ActionTradeBase> collect = this.villagerTradeActions.stream().filter(actionTradeBase -> actionTradeBase.getProfession() == event.getType()).collect(Collectors.toList());
            collect.forEach(IUndoableAction::undo);
            collect.forEach(actionTradeBase -> actionTradeBase.apply((List)event.getTrades().computeIfAbsent(actionTradeBase.getLevel(), value -> new ArrayList())));
            this.villagerTradeActions.removeAll(collect);
            this.ranEvents = true;
        });
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, final BiFunction<Entity, Random, @ZenCodeType.Nullable MerchantOffer> offerGenerator) {
        this.addTradeInternal(profession, villagerLevel, new VillagerTrades.ITrade(){

            @Nullable
            public MerchantOffer func_221182_a(Entity trader, Random rand) {
                return (MerchantOffer)offerGenerator.apply(trader, rand);
            }
        });
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, int emeralds, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTrade trade = new BasicTrade(emeralds, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, ItemStack input1, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTrade trade = new BasicTrade(input1, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(VillagerProfession profession, int villagerLevel, ItemStack input1, ItemStack input2, ItemStack forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTrade trade = new BasicTrade(input1, input2, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void removeBasicTrade(VillagerProfession profession, int villagerLevel, IItemStack forSale, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack price, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack price2) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof BasicTrade) {
                boolean saleMatches = forSale.matches(new MCItemStackMutable(BasicTradeExposer.getForSale(trade)));
                if (price.isEmpty() && price2.isEmpty()) {
                    return saleMatches;
                }
                boolean priceMatches = price.matches(new MCItemStackMutable(BasicTradeExposer.getPrice(trade)));
                if (!price.isEmpty() && price2.isEmpty()) {
                    return saleMatches && priceMatches;
                }
                boolean price2Matches = price2.matches(new MCItemStackMutable(BasicTradeExposer.getPrice2(trade)));
                return saleMatches && priceMatches && price2Matches;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeEmeraldForItemsTrade(VillagerProfession profession, int villagerLevel, Item tradeFor) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.EmeraldForItemsTrade) {
                return ((VillagerTrades.EmeraldForItemsTrade)trade).field_221183_a == tradeFor;
            }
            if (trade instanceof BasicTrade) {
                return BasicTradeExposer.getForSale(trade).func_77973_b() == tradeFor;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsForEmeraldsTrade(VillagerProfession profession, int villagerLevel, IItemStack sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.ItemsForEmeraldsTrade) {
                return sellingItem.matches(new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsTrade)trade).field_221208_a));
            }
            if (trade instanceof BasicTrade) {
                return new MCItemStackMutable(BasicTradeExposer.getPrice(trade)).matches(sellingItem);
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsForEmeraldsAndItemsTrade(VillagerProfession profession, int villagerLevel, IItemStack sellingItem, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.ItemsForEmeraldsAndItemsTrade) {
                if (sellingItem.matches(new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsAndItemsTrade)trade).field_221203_d))) {
                    return buyingItem.matches(new MCItemStackMutable(((VillagerTrades.ItemsForEmeraldsAndItemsTrade)trade).field_221200_a));
                }
            } else if (trade instanceof BasicTrade && sellingItem.matches(new MCItemStackMutable(BasicTradeExposer.getPrice(trade)))) {
                return buyingItem.matches(new MCItemStackMutable(BasicTradeExposer.getForSale(trade)));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemWithPotionForEmeraldsAndItemsTrade(VillagerProfession profession, int villagerLevel, IItemStack potionStack, Item sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade && potionStack.matches(new MCItemStackMutable(((VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade)trade).field_221219_a))) {
                return sellingItem == ((VillagerTrades.ItemWithPotionForEmeraldsAndItemsTrade)trade).field_221224_f;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeDyedArmorForEmeraldsTrade(VillagerProfession profession, int villagerLevel, Item buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.DyedArmorForEmeraldsTrade) {
                return ((VillagerTrades.DyedArmorForEmeraldsTrade)trade).field_221233_a == buyingItem;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeEmeraldForMapTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.EmeraldForMapTrade);
    }

    @ZenCodeType.Method
    public void removeEnchantedBookForEmeraldsTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.EnchantedBookForEmeraldsTrade);
    }

    @ZenCodeType.Method
    public void removeEnchantedItemForEmeraldsTrade(VillagerProfession profession, int villagerLevel, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof VillagerTrades.EnchantedItemForEmeraldsTrade) {
                return buyingItem.matches(new MCItemStackMutable(((VillagerTrades.EnchantedItemForEmeraldsTrade)trade).field_221195_a));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeSuspiciousStewForEmeraldTrade(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof VillagerTrades.SuspiciousStewForEmeraldTrade);
    }

    @ZenCodeType.Method
    public void removeAllTrades(VillagerProfession profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> true);
    }

    @ZenCodeType.Method
    public void removeTrade(VillagerProfession profession, int villagerLevel, IIngredient buying, IIngredient selling, @ZenCodeType.Optional(value="<item:minecraft:air>") IIngredient secondBuying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ITrade, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            if (!buying.matches(tradeObject.getBuyingStack())) {
                return false;
            }
            if (!selling.matches(tradeObject.getSellingStack())) {
                return false;
            }
            return secondBuying.matches(tradeObject.getBuyingStackSecond());
        });
    }

    @ZenCodeType.Method
    public void removeTradesSelling(VillagerProfession profession, int villagerLevel, IIngredient selling) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ITrade, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return selling.matches(tradeObject.getSellingStack());
        });
    }

    @ZenCodeType.Method
    public void removeTradesBuying(VillagerProfession profession, int villagerLevel, IIngredient buying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ITrade, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return buying.matches(tradeObject.getBuyingStack());
        });
    }

    @ZenCodeType.Method
    public void removeTradesBuying(VillagerProfession profession, int villagerLevel, IIngredient buying, IIngredient secondBuying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<VillagerTrades.ITrade, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            if (!buying.matches(tradeObject.getBuyingStack())) {
                return false;
            }
            return secondBuying.matches(tradeObject.getBuyingStackSecond());
        });
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, int emeralds, ItemStack forSale, int maxTrades, int xp) {
        BasicTrade trade = new BasicTrade(emeralds, forSale, maxTrades, xp, 1.0f);
        this.addWanderingTradeInternal(rarity, trade);
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, IItemStack price, IItemStack forSale, int maxTrades, int xp) {
        BasicTrade trade = new BasicTrade(price.getInternal(), forSale.getInternal(), maxTrades, xp, 1.0f);
        this.addWanderingTradeInternal(rarity, trade);
    }

    @Deprecated
    public void removeWanderingTrade(int rarity, IItemStack tradeFor) {
        this.removeWanderingTrade(rarity, (IIngredient)tradeFor);
    }

    @ZenCodeType.Method
    public void removeWanderingTrade(int rarity, IIngredient tradeFor) {
        this.removeWanderingTradeInternal(rarity, trade -> {
            Function<VillagerTrades.ITrade, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return tradeFor.matches(tradeObject.getSellingStack());
        });
    }

    @Deprecated
    @ZenCodeType.Method
    public void removeAllWanderinTrades(int rarity) {
        this.removeWanderingTradeInternal(rarity, trade -> true);
    }

    @Deprecated
    @ZenCodeType.Method
    public void removeAllWanderingTrades(int rarity) {
        this.removeWanderingTradeInternal(rarity, trade -> true);
    }

    private void addTradeInternal(VillagerProfession profession, int villagerLevel, VillagerTrades.ITrade trade) {
        this.apply(new ActionAddTrade(profession, villagerLevel, trade), false);
    }

    private void addTradeInternal(VillagerProfession profession, int villagerLevel, BasicTrade trade) {
        this.apply(new ActionAddTrade(profession, villagerLevel, trade), false);
    }

    private void addWanderingTradeInternal(int villagerLevel, BasicTrade trade) {
        this.apply(new ActionAddWanderingTrade(villagerLevel, trade), true);
    }

    private void removeTradeInternal(VillagerProfession profession, int villagerLevel, ITradeRemover remover) {
        this.apply(new ActionRemoveTrade(profession, villagerLevel, remover), false);
    }

    private void removeWanderingTradeInternal(int villagerLevel, ITradeRemover remover) {
        this.apply(new ActionRemoveWanderingTrade(villagerLevel, remover), true);
    }

    private void apply(ActionTradeBase action, boolean wandering) {
        if (CraftTweakerAPI.isServer() && !this.ranEvents) {
            if (wandering) {
                this.wanderingTradeActions.add(action);
            } else {
                this.villagerTradeActions.add(action);
            }
        }
        CraftTweakerAPI.apply(action);
    }
}

