/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.misc;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionAddBrewingRecipe;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionRemoveBrewingRecipe;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionRemoveBrewingRecipeByInput;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionRemoveBrewingRecipeByPotionInput;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionRemoveBrewingRecipeByPotionOutput;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionRemoveBrewingRecipeByReagent;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionRemovePotionBrewingRecipe;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.Brewing")
@Document(value="vanilla/api/brewing/Brewing")
public class CTBrewing {
    @ZenCodeGlobals.Global(value="brewing")
    public static final CTBrewing INSTANCE = new CTBrewing();
    public List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public CTBrewing() {
        try {
            Field recipesField = BrewingRecipeRegistry.class.getDeclaredField("recipes");
            recipesField.setAccessible(true);
            this.recipes = (List)recipesField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @ZenCodeType.Method
    public void addRecipe(IItemStack output, IIngredient reagent, IIngredient input) {
        BrewingRecipe recipe = new BrewingRecipe(input.asVanillaIngredient(), reagent.asVanillaIngredient(), output.getInternal());
        CraftTweakerAPI.apply(new ActionAddBrewingRecipe(this.recipes, recipe));
    }

    @ZenCodeType.Method
    public void removeRecipe(Potion output, IItemStack reagent, Potion input) {
        CraftTweakerAPI.apply(new ActionRemovePotionBrewingRecipe(this.recipes, output, reagent, input));
    }

    @ZenCodeType.Method
    public void removeRecipe(IItemStack output, IItemStack reagent, IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipe(this.recipes, output, reagent, input));
    }

    @ZenCodeType.Method
    public void removeRecipeByReagent(IItemStack reagent) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByReagent(this.recipes, reagent));
    }

    @ZenCodeType.Method
    public void removeRecipeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByInput(this.recipes, input));
    }

    @ZenCodeType.Method
    public void removeRecipeByOutputPotion(Potion output) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByPotionOutput(this.recipes, output));
    }

    @ZenCodeType.Method
    public void removeRecipeByInputPotion(Potion input) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByPotionInput(this.recipes, input));
    }
}

