/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.items;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.impl.events.CTEventHandler;
import net.minecraftforge.fml.LogicalSide;

public class ActionSetBurnTime
implements IUndoableAction {
    private IIngredient ingredient;
    private int newBurnTime;

    public ActionSetBurnTime(IIngredient ingredient, int newBurnTime) {
        this.ingredient = ingredient;
        this.newBurnTime = newBurnTime;
    }

    @Override
    public void apply() {
        CTEventHandler.BURN_TIMES.put(this.ingredient, this.newBurnTime);
    }

    @Override
    public String describe() {
        return String.format("Setting burn time of: %s to %s", this.ingredient.getCommandString(), this.newBurnTime);
    }

    @Override
    public void undo() {
        CTEventHandler.BURN_TIMES.entrySet().removeIf(entry -> this.ingredient.contains((IIngredient)entry.getKey()));
    }

    @Override
    public String describeUndo() {
        return "Undoing setting of burn time for stack: " + this.ingredient.getCommandString();
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return true;
    }
}

