/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.preprocessors;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.annotations.Preprocessor;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.PreprocessorMatch;
import com.blamejared.crafttweaker.api.zencode.impl.FileAccessSingle;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Preprocessor
public class PriorityPreprocessor
implements IPreprocessor {
    public static final PriorityPreprocessor INSTANCE = new PriorityPreprocessor();

    private PriorityPreprocessor() {
    }

    @Override
    public String getName() {
        return "priority";
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return "10";
    }

    @Override
    public boolean apply(@Nonnull FileAccessSingle file, ScriptLoadingOptions scriptLoadingOptions, @Nonnull List<PreprocessorMatch> preprocessorMatches) {
        if (preprocessorMatches.size() > 1) {
            CraftTweakerAPI.logWarning("There are more than one #priority preprocessors in the file " + file.getFileName(), new Object[0]);
        }
        try {
            Integer.parseInt(preprocessorMatches.get(0).getContent().trim());
        }
        catch (NumberFormatException ex) {
            CraftTweakerAPI.logWarning("Incorrect Priority value: " + StringUtils.wrap(preprocessorMatches.get(0).getContent().trim(), "`", false), new Object[0]);
            preprocessorMatches.set(0, new PreprocessorMatch(this, -1, this.getDefaultValue()));
        }
        return true;
    }

    @Override
    public int compare(FileAccessSingle o1, FileAccessSingle o2) {
        int i1 = Integer.parseInt(o1.getMatchesFor(this).get(0).getContent().trim());
        int i2 = Integer.parseInt(o2.getMatchesFor(this).get(0).getContent().trim());
        return Integer.compare(i2, i1);
    }

    @Override
    public int getPriority() {
        return 100;
    }
}

