/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.entity;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.entity.EntityIngredient")
@Document(value="vanilla/api/entity/EntityIngredient")
public abstract class CTEntityIngredient
implements CommandStringDisplayable {
    CTEntityIngredient() {
    }

    @Override
    public abstract String getCommandString();

    public abstract <T> T mapTo(Function<EntityType<?>, T> var1, BiFunction<ITag<EntityType<?>>, Integer, T> var2, Function<Stream<T>, T> var3);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public CTEntityIngredient asCompound(CTEntityIngredient other) {
        ArrayList<CTEntityIngredient> ingredients = new ArrayList<CTEntityIngredient>();
        if (other instanceof CompoundEntityIngredient) {
            ingredients.addAll(((CompoundEntityIngredient)other).elements);
        } else {
            ingredients.add(other);
        }
        if (this instanceof CompoundEntityIngredient) {
            ((CompoundEntityIngredient)this).elements.addAll(ingredients);
            return this;
        }
        ingredients.add(this);
        return new CompoundEntityIngredient(ingredients);
    }

    public static final class CompoundEntityIngredient
    extends CTEntityIngredient {
        final List<CTEntityIngredient> elements;

        public CompoundEntityIngredient(List<CTEntityIngredient> elements) {
            this.elements = elements;
        }

        @Override
        public String getCommandString() {
            return this.elements.stream().map(CTEntityIngredient::getCommandString).collect(Collectors.joining(" | "));
        }

        @Override
        public <T> T mapTo(Function<EntityType<?>, T> typeMapper, BiFunction<ITag<EntityType<?>>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            Stream<Object> stream = this.elements.stream().map(element -> element.mapTo(typeMapper, tagMapper, compoundMapper));
            return compoundMapper.apply(stream);
        }
    }

    public static final class EntityTagWithAmountIngredient
    extends CTEntityIngredient {
        final MCTagWithAmount<MCEntityType> tag;

        public EntityTagWithAmountIngredient(MCTagWithAmount<MCEntityType> tag) {
            this.tag = tag;
        }

        @Override
        public String getCommandString() {
            return this.tag.getCommandString();
        }

        @Override
        public <T> T mapTo(Function<EntityType<?>, T> typeMapper, BiFunction<ITag<EntityType<?>>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return tagMapper.apply(this.tag.getTag().getInternalRaw(), this.tag.getAmount());
        }
    }

    public static final class EntityTypeIngredient
    extends CTEntityIngredient {
        final MCEntityType entityType;

        public EntityTypeIngredient(MCEntityType entityType) {
            this.entityType = entityType;
        }

        @Override
        public String getCommandString() {
            return this.entityType.getCommandString();
        }

        @Override
        public <T> T mapTo(Function<EntityType<?>, T> typeMapper, BiFunction<ITag<EntityType<?>>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return typeMapper.apply(this.entityType.getInternal());
        }
    }
}

