/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigGeneral {
    public final ForgeConfigSpec.ConfigValue<Integer> strongholdStartMinY;
    public final ForgeConfigSpec.ConfigValue<Integer> strongholdStartMaxY;
    public final ForgeConfigSpec.ConfigValue<Integer> strongholdMaxY;
    public final ForgeConfigSpec.ConfigValue<Integer> strongholdSize;
    public final ForgeConfigSpec.ConfigValue<Double> cobwebReplacementChanceNormal;
    public final ForgeConfigSpec.ConfigValue<Double> cobwebReplacementChanceSpawner;
    public final ForgeConfigSpec.ConfigValue<Double> torchSpawnRate;
    public final ForgeConfigSpec.ConfigValue<Double> lanternSpawnRate;

    public ConfigGeneral(ForgeConfigSpec.Builder BUILDER) {
        BUILDER.comment("##########################################################################################################\n# General settings.\n##########################################################################################################").push("General");
        this.strongholdStartMinY = BUILDER.comment(" The minimum y-value at which the STARTING ROOM of the stronghold can spawn.\n Note that the various pieces of the stronghold can extend above or below this value.\n Default: 30").worldRestart().define("Min Start Y", (Object)30);
        this.strongholdStartMaxY = BUILDER.comment(" The maximum y-value at which the STARTING ROOM of the stronghold can spawn.\n Note that the various pieces of the stronghold can extend above or below this value.\n Default: 31").worldRestart().define("Max Start Y", (Object)31);
        this.strongholdMaxY = BUILDER.comment(" The maximum y-value at which ANY piece of the stronghold can spawn.\n If any piece attempts to spawn such that any part of it is above this y-value,\n it will not spawn.\n In other words, this is a hard cap above which no part of the stronghold can generate.\n Default: 60").worldRestart().define("Max Y", (Object)60);
        this.strongholdSize = BUILDER.comment(" The max number of \"pieces\" the stronghold will generate from the center.\n This number controls the general size of strongholds. Bigger number = bigger strongholds.\n It is HIGHLY recommended to keep this an even number!\n Default: 16").worldRestart().define("Stronghold Size", (Object)16);
        this.cobwebReplacementChanceNormal = BUILDER.comment(" The rate at which cobwebs will spawn in various parts of the stronghold.\n Default: 0.1").worldRestart().define("Cobweb Spawn Rate (NORMAL)", (Object)0.1);
        this.cobwebReplacementChanceSpawner = BUILDER.comment(" The rate at which cobwebs will spawn around spider spawners in libraries.\n Default: 0.3").worldRestart().define("Cobweb Spawn Rate (SPAWNER)", (Object)0.3);
        this.torchSpawnRate = BUILDER.comment(" The rate at which torches spawn throughout the stronghold.\n Default: 0.1").worldRestart().define("Torch Spawn Rate", (Object)0.1);
        this.lanternSpawnRate = BUILDER.comment(" The rate at which lanterns spawn throughout the stronghold.\n Default: 0.2").worldRestart().define("Lantern Spawn Rate", (Object)0.2);
        BUILDER.pop();
    }
}

