/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;
import xfacthd.framedblocks.common.util.DoubleBlockSoundType;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public abstract class FramedDoubleTileEntity
extends FramedTileEntity {
    public static final ModelProperty<IModelData> DATA_LEFT = new ModelProperty();
    public static final ModelProperty<IModelData> DATA_RIGHT = new ModelProperty();
    private final IModelData multiModelData = new ModelDataMap.Builder().build();
    private final FramedBlockData modelData = new FramedBlockData(true);
    private final DoubleBlockSoundType soundType = new DoubleBlockSoundType(this);
    private ItemStack camoStack = ItemStack.field_190927_a;
    private BlockState camoState = Blocks.field_150350_a.func_176223_P();

    public FramedDoubleTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void setCamo(ItemStack camoStack, BlockState camoState, boolean secondary) {
        if (secondary) {
            int light = this.getLightValue();
            this.camoStack = camoStack;
            this.camoState = camoState;
            this.func_70296_d();
            if (this.getLightValue() != light) {
                this.doLightUpdate();
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        } else {
            super.setCamo(camoStack, camoState, false);
        }
    }

    @Override
    protected void applyCamo(ItemStack camoStack, BlockState camoState, BlockRayTraceResult hit) {
        if (this.hitSecondary(hit)) {
            this.camoStack = camoStack;
            this.camoState = camoState;
        } else {
            super.applyCamo(camoStack, camoState, hit);
        }
    }

    public BlockState getCamoStateTwo() {
        return this.camoState;
    }

    public ItemStack getCamoStackTwo() {
        return this.camoStack;
    }

    @Override
    public int getLightValue() {
        return Math.max(this.camoState.func_185906_d(), super.getLightValue());
    }

    @Override
    public void addCamoDrops(List<ItemStack> drops) {
        super.addCamoDrops(drops);
        if (!this.camoStack.func_190926_b()) {
            drops.add(this.camoStack);
        }
    }

    @Override
    public MaterialColor getMapColor() {
        if (!this.camoState.func_196958_f()) {
            return this.camoState.func_185909_g((IBlockReader)this.field_145850_b, this.field_174879_c);
        }
        return super.getMapColor();
    }

    @Override
    protected BlockState getCamoState(BlockRayTraceResult hit) {
        return this.hitSecondary(hit) ? this.getCamoStateTwo() : this.getCamoState();
    }

    @Override
    protected ItemStack getCamoStack(BlockRayTraceResult hit) {
        return this.hitSecondary(hit) ? this.getCamoStackTwo() : this.getCamoStack();
    }

    @Override
    protected boolean isCamoSolid() {
        return super.isCamoSolid() && !this.camoState.func_196958_f() && this.camoState.func_200015_d((IBlockReader)this.field_145850_b, this.field_174879_c);
    }

    @Override
    public float getCamoBlastResistance(Explosion explosion) {
        return Math.max(this.getCamoState().getExplosionResistance((IBlockReader)this.field_145850_b, this.field_174879_c, explosion), this.getCamoStateTwo().getExplosionResistance((IBlockReader)this.field_145850_b, this.field_174879_c, explosion));
    }

    @Override
    public boolean isCamoFlammable(Direction face) {
        BlockState camo = this.getCamoState(face);
        if (!(!camo.func_196958_f() || this.getCamoState().func_196958_f() && this.getCamoStateTwo().func_196958_f())) {
            return !(!this.getCamoState().func_196958_f() && !this.getCamoState().isFlammable((IBlockReader)this.field_145850_b, this.field_174879_c, face) || !this.getCamoStateTwo().func_196958_f() && !this.getCamoStateTwo().isFlammable((IBlockReader)this.field_145850_b, this.field_174879_c, face));
        }
        if (!camo.func_196958_f()) {
            return camo.isFlammable((IBlockReader)this.field_145850_b, this.field_174879_c, face);
        }
        return true;
    }

    @Override
    public int getCamoFlammability(Direction face) {
        int flammabilityTwo;
        int flammabilityOne = super.getCamoFlammability(face);
        int n = flammabilityTwo = this.getCamoStateTwo().func_196958_f() ? -1 : this.getCamoStateTwo().getFlammability((IBlockReader)this.field_145850_b, this.field_174879_c, face);
        if (flammabilityOne == -1) {
            return flammabilityTwo;
        }
        if (flammabilityTwo == -1) {
            return flammabilityOne;
        }
        return Math.min(flammabilityOne, flammabilityTwo);
    }

    public final SoundType getSoundType() {
        return this.soundType;
    }

    protected abstract boolean hitSecondary(BlockRayTraceResult var1);

    public abstract DoubleSoundMode getSoundMode();

    @Override
    protected void writeToDataPacket(CompoundNBT nbt) {
        super.writeToDataPacket(nbt);
        nbt.func_218657_a("camo_stack_two", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state_two", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
    }

    @Override
    protected boolean readFromDataPacket(CompoundNBT nbt) {
        this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack_two"));
        boolean needUpdate = false;
        BlockState newState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state_two"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setWorld(this.field_145850_b);
            this.modelData.setPos(this.field_174879_c);
            this.modelData.setCamoState(this.camoState);
            needUpdate = true;
        }
        return super.readFromDataPacket(nbt) || needUpdate;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("camo_stack_two", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state_two", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        return nbt;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack_two"));
        BlockState newState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state_two"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setWorld(this.field_145850_b);
            this.modelData.setPos(this.field_174879_c);
            this.modelData.setCamoState(this.camoState);
        }
    }

    @Override
    public IModelData getModelData() {
        this.multiModelData.setData(DATA_LEFT, (Object)super.getModelData());
        this.multiModelData.setData(DATA_RIGHT, (Object)this.modelData);
        return this.multiModelData;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("camo_stack_two", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state_two", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        BlockState camoState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state_two"));
        if (camoState.func_196958_f() || this.isValidBlock(camoState, null)) {
            this.camoState = camoState;
            this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack_two"));
        } else {
            FramedBlocks.LOGGER.warn("Framed Block of type \"{}\" at position {} contains an invalid camo of type \"{}\", removing camo! This might be caused by a config or tag change!", (Object)state.func_177230_c().getRegistryName(), (Object)this.field_174879_c, (Object)camoState.func_177230_c().getRegistryName());
        }
    }
}

