/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class VerticalHalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        switch (adjBlock) {
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return VerticalHalfStairsSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_VERTICAL_STAIRS: {
                return VerticalHalfStairsSkipPredicate.testAgainstVerticalStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLAB: {
                return VerticalHalfStairsSkipPredicate.testAgainstSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLAB: {
                return VerticalHalfStairsSkipPredicate.testAgainstDoubleSlab(world, pos, dir, top, side);
            }
            case FRAMED_SLAB_EDGE: {
                return VerticalHalfStairsSkipPredicate.testAgainstSlabEdge(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLAB_CORNER: {
                return VerticalHalfStairsSkipPredicate.testAgainstSlabCorner(world, pos, dir, top, adjState, side);
            }
            case FRAMED_STAIRS: {
                return VerticalHalfStairsSkipPredicate.testAgainstStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_HALF_STAIRS: {
                return VerticalHalfStairsSkipPredicate.testAgainstHalfStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLOPE_SLAB: {
                return VerticalHalfStairsSkipPredicate.testAgainstSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_ELEVATED_SLOPE_SLAB: {
                return VerticalHalfStairsSkipPredicate.testAgainstElevatedSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_SLAB: {
                return VerticalHalfStairsSkipPredicate.testAgainstDoubleSlopeSlab(world, pos, dir, top, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_SLAB: {
                return VerticalHalfStairsSkipPredicate.testAgainstInverseDoubleSlopeSlab(world, pos, dir, top, adjState, side);
            }
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            if (adjTop == top || adjDir != dir) {
                return false;
            }
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir.func_176734_d() && adjDir == dir.func_176735_f() || side == dir.func_176746_e() && adjDir == dir.func_176746_e()) {
            return adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (side == Direction.DOWN && !top && !adjType.isTop() || side == Direction.UP && top && !adjType.isBottom()) {
            return adjDir == dir && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop == top && (side == dir || side == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side == dir || side == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop != top) {
            return false;
        }
        if ((side == dir || side == dir.func_176735_f()) && adjDir == side.func_176734_d()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176734_d() && adjDir == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop == top && adjDir == dir && (side == dir.func_176734_d() || side == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        boolean adjTop = adjState.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)StairsBlock.field_176310_M);
        if (adjTop != top || !StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return false;
        }
        if (side == dir || side == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (adjTop != top || adjDir != side) {
            return false;
        }
        if (adjRight && adjDir == dir.func_176734_d() || !adjRight && adjDir == dir.func_176746_e()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (adjTop == top && (side == dir || side == dir.func_176735_f()) && adjDir == side.func_176734_d()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop == top && (side == dir || side == dir.func_176735_f()) && adjDir == side) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (!(adjTop != top || side != dir && side != dir.func_176735_f() || adjDir != side && adjDir != side.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side != dir && side != dir.func_176735_f()) {
            return false;
        }
        if (!top && adjDir == side || top && adjDir == side.func_176734_d()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

