/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class SlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        boolean topHalf = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP_HALF);
        switch (adjBlock) {
            case FRAMED_SLOPE_SLAB: {
                return SlopeSlabSkipPredicate.testAgainstSlopeSlab(world, pos, dir, top, topHalf, adjState, side);
            }
            case FRAMED_ELEVATED_SLOPE_SLAB: {
                return SlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(world, pos, dir, topHalf, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_SLAB: {
                return SlopeSlabSkipPredicate.testAgainstDoubleSlopeSlab(world, pos, dir, topHalf, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_SLAB: {
                return SlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(world, pos, dir, top, topHalf, adjState, side);
            }
            case FRAMED_SLAB: {
                return SlopeSlabSkipPredicate.testAgainstSlab(world, pos, dir, topHalf, adjState, side);
            }
            case FRAMED_DOUBLE_SLAB: {
                return SlopeSlabSkipPredicate.testAgainstDoubleSlab(world, pos, dir, topHalf, side);
            }
            case FRAMED_SLAB_EDGE: {
                return SlopeSlabSkipPredicate.testAgainstSlabEdge(world, pos, dir, topHalf, adjState, side);
            }
            case FRAMED_STAIRS: {
                return SlopeSlabSkipPredicate.testAgainstStairs(world, pos, dir, topHalf, adjState, side);
            }
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return SlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, topHalf, adjState, side);
            }
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir.func_176746_e() || side == dir.func_176735_f()) {
            return adjDir == dir && adjTop == top && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (side == dir) {
            return adjDir == dir.func_176734_d() && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        return side == dir && adjDir == dir && adjTop == topHalf && SideSkipPredicate.compareState(world, pos, side, dir);
    }

    private static boolean testAgainstDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf != topHalf) {
            return false;
        }
        if (side == dir.func_176746_e() || side == dir.func_176735_f()) {
            return (adjDir == dir || adjDir == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (side == dir) {
            return (adjDir == dir || adjDir == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, dir, dir.func_176734_d());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir.func_176746_e() || side == dir.func_176735_f()) {
            return (adjDir == dir && topHalf && !top || adjDir == dir.func_176734_d() && !topHalf && top) && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        if (side == dir && (adjDir == dir && !topHalf || adjDir == dir.func_176734_d() && topHalf)) {
            return SideSkipPredicate.compareState(world, pos, side, dir, dir.func_176734_d());
        }
        return false;
    }

    private static boolean testAgainstSlab(IBlockReader world, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        return side == dir && adjTop == topHalf && SideSkipPredicate.compareState(world, pos, side, dir);
    }

    private static boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, Direction dir, boolean topHalf, Direction side) {
        return side == dir && SideSkipPredicate.compareState(world, pos, side, dir, topHalf ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstSlabEdge(IBlockReader world, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        return side == dir && adjDir == dir.func_176734_d() && adjTop == topHalf && SideSkipPredicate.compareState(world, pos, side, dir);
    }

    private static boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (topHalf == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return side == dir && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjTop != topHalf || side != dir) {
            return false;
        }
        if (adjDir == dir.func_176734_d() || adjDir == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }
}

