/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class SlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        switch (adjBlock) {
            case FRAMED_SLAB_CORNER: {
                return this.testAgainstCorner(world, pos, dir, top, adjState, side);
            }
            case FRAMED_SLAB_EDGE: {
                return this.testAgainstEdge(world, pos, dir, top, adjState, side);
            }
            case FRAMED_CORNER_PILLAR: {
                return this.testAgainstPillar(world, pos, dir, top, adjState, side);
            }
            case FRAMED_STAIRS: {
                return this.testAgainstStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_VERTICAL_STAIRS: {
                return this.testAgainstVerticalStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_HALF_STAIRS: {
                return SlabCornerSkipPredicate.testAgainstHalfStairs(world, pos, dir, top, adjState, side);
            }
            case FRAMED_VERTICAL_HALF_STAIRS: {
                return SlabCornerSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, top, adjState, side);
            }
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == Direction.DOWN && !top && adjTop || side == Direction.UP && top && !adjTop) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == dir.func_176735_f() || side == dir.func_176735_f() && adjDir == dir) {
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPillar(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        if (side.func_176740_k() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (top != adjTop) {
            return false;
        }
        if (adjShape == StairsShape.OUTER_LEFT) {
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        if (adjShape == StairsShape.OUTER_RIGHT) {
            return dir.func_176735_f() == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (adjType.isTop() == top || dir != adjDir) {
            return false;
        }
        if (side.func_176740_k() == Direction.Axis.Y || side == dir || side == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (adjTop != top) {
            return false;
        }
        if (adjRight && adjDir != dir.func_176735_f() || !adjRight && adjDir != dir) {
            return false;
        }
        if (adjRight && side == dir.func_176735_f() || !adjRight && side == dir || side.func_176740_k() == Direction.Axis.Y && side == Direction.UP == adjTop) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (adjDir != dir || adjTop != top) {
            return false;
        }
        return (side == dir || side == dir.func_176735_f()) && SideSkipPredicate.compareState(world, pos, side);
    }
}

