/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class HalfStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction baseFace;
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        boolean right = (Boolean)state.func_177229_b((Property)PropertyHolder.RIGHT);
        Direction stairFace = right ? dir.func_176746_e() : dir.func_176735_f();
        Direction direction = baseFace = top ? Direction.UP : Direction.DOWN;
        if (adjBlock == BlockType.FRAMED_HALF_STAIRS) {
            return HalfStairsSkipPredicate.testAgainstHalfStairs(world, pos, dir, top, right, stairFace, adjState, side);
        }
        if (side == stairFace) {
            if (adjBlock == BlockType.FRAMED_STAIRS) {
                return HalfStairsSkipPredicate.testAgainstStairs(world, pos, top, adjState, side);
            }
            if (adjBlock == BlockType.FRAMED_VERTICAL_STAIRS) {
                return HalfStairsSkipPredicate.testAgainstVerticalStairs(world, pos, dir, top, right, adjState, side);
            }
        } else {
            switch (adjBlock) {
                case FRAMED_SLAB_EDGE: {
                    return HalfStairsSkipPredicate.testAgainstSlabEdge(world, pos, dir, top, right, baseFace, adjState, side);
                }
                case FRAMED_CORNER_PILLAR: {
                    return HalfStairsSkipPredicate.testAgainstCornerPillar(world, pos, dir, right, baseFace, adjState, side);
                }
                case FRAMED_SLAB_CORNER: {
                    return HalfStairsSkipPredicate.testAgainstSlabCorner(world, pos, dir, top, right, baseFace, adjState, side);
                }
                case FRAMED_PANEL: {
                    return HalfStairsSkipPredicate.testAgainstPanel(world, pos, dir, right, baseFace, adjState, side);
                }
                case FRAMED_DOUBLE_PANEL: {
                    return HalfStairsSkipPredicate.testAgainstDoublePanel(world, pos, dir, stairFace, baseFace, adjState, side);
                }
                case FRAMED_VERTICAL_HALF_STAIRS: {
                    return HalfStairsSkipPredicate.testAgainstVerticalHalfStairs(world, pos, dir, top, right, adjState, side);
                }
                case FRAMED_SLOPE_PANEL: {
                    return HalfStairsSkipPredicate.testAgainstSlopePanel(world, pos, dir, top, right, adjState, side);
                }
                case FRAMED_EXTENDED_SLOPE_PANEL: {
                    return HalfStairsSkipPredicate.testAgainstExtendedSlopePanel(world, pos, dir, top, right, adjState, side);
                }
                case FRAMED_DOUBLE_SLOPE_PANEL: {
                    return HalfStairsSkipPredicate.testAgainstDoubleSlopePanel(world, pos, dir, top, right, adjState, side);
                }
                case FRAMED_INV_DOUBLE_SLOPE_PANEL: {
                    return HalfStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(world, pos, dir, top, right, adjState, side);
                }
            }
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, Direction stairFace, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (side == stairFace) {
            return adjDir == dir && adjTop == top && adjRight != right && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side.func_176740_k() == Direction.Axis.Y) {
            return adjDir == dir && adjTop != top && adjRight == right && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir) {
            return adjDir == dir.func_176734_d() && adjRight != right && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(IBlockReader world, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)StairsBlock.field_176309_a);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)StairsBlock.field_176310_M);
        boolean adjTop = adjState.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        return top == adjTop && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (right && adjDir == dir || !right && adjDir == dir.func_176746_e()) {
            return adjType.isTop() != top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (right && adjDir == dir.func_176746_e() || !right && adjDir == dir.func_176735_f()) {
            return adjTop == top == (side == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstCornerPillar(IBlockReader world, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.func_176734_d() && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir && (right && adjDir == dir.func_176734_d() || !right && adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == baseFace.func_176734_d() && (right && adjDir == dir.func_176746_e() || !right && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace.func_176734_d() && side != dir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (right && adjDir == dir.func_176746_e() || !right && adjDir == dir) {
            return adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, boolean right, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (right && adjDir == dir.func_176746_e() || !right && adjDir == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, Direction stairFace, Direction baseFace, BlockState adjState, Direction side) {
        if (side != baseFace && side != dir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        return adjDir.func_176740_k() != dir.func_176740_k() && SideSkipPredicate.compareState(world, pos, side, stairFace);
    }

    private static boolean testAgainstVerticalHalfStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side != dir.func_176734_d() || adjTop != top) {
            return false;
        }
        if (right && adjDir == dir.func_176734_d() || !right && adjDir == dir.func_176735_f()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (side != adjRot.withFacing(adjDir) || adjRot.isVertical() && top != (adjRot == Rotation.UP)) {
            return false;
        }
        if (!right && (adjDir == dir.func_176735_f() && !adjFront || adjDir == dir.func_176746_e() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (right && (adjDir == dir.func_176746_e() && !adjFront || adjDir == dir.func_176735_f() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (adjRot.withFacing(adjDir) != side.func_176734_d()) {
            return false;
        }
        if (adjRot.isVertical() && top == (adjRot == Rotation.DOWN) && (!right && adjDir == dir.func_176735_f() || right && adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (!adjRot.isVertical() && (!right && adjDir == dir.func_176735_f() || right && adjDir == dir.func_176746_e())) {
            return right == (adjRot == Rotation.RIGHT) && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (side.func_176740_k() != adjRot.withFacing(adjDir).func_176740_k() || adjRot.isVertical() && top != (side == Direction.UP)) {
            return false;
        }
        if (!right && (adjDir == dir.func_176735_f() && !adjFront || adjDir == dir.func_176746_e() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (right && (adjDir == dir.func_176746_e() && !adjFront || adjDir == dir.func_176735_f() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (side.func_176740_k() != adjRot.withFacing(adjDir).func_176740_k() || adjRot.isVertical() && top != (side == Direction.UP)) {
            return false;
        }
        if (adjRot.isVertical()) {
            boolean sameOrientation;
            boolean bl = sameOrientation = top == (adjRot == Rotation.UP);
            if (!right && (adjDir == dir.func_176735_f() && !sameOrientation || adjDir == dir.func_176746_e() && sameOrientation)) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
            if (right && (adjDir == dir.func_176746_e() && !sameOrientation || adjDir == dir.func_176735_f() && sameOrientation)) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
        } else if (right == (adjRot == Rotation.RIGHT) && (adjDir == dir.func_176746_e() || adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

