/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedCollapsibleTileEntity;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class CollapsibleBlockSkipPredicate
implements SideSkipPredicate {
    private static final Table<CollapseFace, Direction, VertexPair> EDGE_MAPPING = CollapsibleBlockSkipPredicate.makeEdgeMappings();

    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        CollapseFace face = (CollapseFace)((Object)state.func_177229_b(PropertyHolder.COLLAPSED_FACE));
        if (face == CollapseFace.NONE || side == face.toDirection().func_176734_d()) {
            return SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        if (side == face.toDirection()) {
            return false;
        }
        TileEntity te = Utils.getTileEntitySafe(world, pos);
        TileEntity adjTe = Utils.getTileEntitySafe(world, pos.func_177972_a(side));
        if (te instanceof FramedCollapsibleTileEntity && adjTe instanceof FramedCollapsibleTileEntity) {
            VertexPair verts = (VertexPair)Preconditions.checkNotNull((Object)EDGE_MAPPING.get((Object)face, (Object)side));
            VertexPair adjVerts = (VertexPair)Preconditions.checkNotNull((Object)EDGE_MAPPING.get((Object)face, (Object)side.func_176734_d()));
            byte[] offsets = ((FramedCollapsibleTileEntity)te).getVertexOffsets();
            byte[] adjOffsets = ((FramedCollapsibleTileEntity)adjTe).getVertexOffsets();
            if (offsets[verts.v1] == adjOffsets[adjVerts.v2] && offsets[verts.v2] == adjOffsets[adjVerts.v1]) {
                return SideSkipPredicate.compareState(world, pos, side);
            }
        }
        return false;
    }

    private static Table<CollapseFace, Direction, VertexPair> makeEdgeMappings() {
        HashBasedTable table = HashBasedTable.create((int)6, (int)4);
        table.put((Object)CollapseFace.UP, (Object)Direction.NORTH, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.UP, (Object)Direction.EAST, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.UP, (Object)Direction.SOUTH, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.UP, (Object)Direction.WEST, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.NORTH, (Object)new VertexPair(1, 2));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.EAST, (Object)new VertexPair(2, 3));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.SOUTH, (Object)new VertexPair(3, 0));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.WEST, (Object)new VertexPair(0, 1));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.WEST, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.EAST, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.EAST, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.EAST, (Object)Direction.NORTH, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.EAST, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.EAST, (Object)Direction.SOUTH, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.EAST, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.WEST, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.WEST, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.WEST, (Object)Direction.SOUTH, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.WEST, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.WEST, (Object)Direction.NORTH, (Object)new VertexPair(1, 0));
        return table;
    }

    private static final class VertexPair {
        private final int v1;
        private final int v2;

        private VertexPair(int v1, int v2) {
            this.v1 = v1;
            this.v2 = v2;
        }
    }
}

