/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import xfacthd.framedblocks.common.block.FramedCollapsibleBlock;
import xfacthd.framedblocks.common.block.FramedCornerPillarBlock;
import xfacthd.framedblocks.common.block.FramedCornerSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoorBlock;
import xfacthd.framedblocks.common.block.FramedDoubleCornerBlock;
import xfacthd.framedblocks.common.block.FramedDoublePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedDoubleThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedExtendedSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedFenceBlock;
import xfacthd.framedblocks.common.block.FramedFloorBlock;
import xfacthd.framedblocks.common.block.FramedGateBlock;
import xfacthd.framedblocks.common.block.FramedHalfPillarBlock;
import xfacthd.framedblocks.common.block.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedInverseDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedInverseDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedLatticeBlock;
import xfacthd.framedblocks.common.block.FramedPanelBlock;
import xfacthd.framedblocks.common.block.FramedPillarBlock;
import xfacthd.framedblocks.common.block.FramedPrismBlock;
import xfacthd.framedblocks.common.block.FramedPrismCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabEdgeBlock;
import xfacthd.framedblocks.common.block.FramedSlopeBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.FramedStairsBlock;
import xfacthd.framedblocks.common.block.FramedThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedTrapDoorBlock;
import xfacthd.framedblocks.common.block.FramedVerticalHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.block.FramedWallSignBlock;
import xfacthd.framedblocks.common.data.skippreds.CollapsibleBlockSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.DoorSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.HalfPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PaneSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PostSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.WallSkipPredicate;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;
import xfacthd.framedblocks.common.util.VoxelShapeGenerator;

public enum BlockType {
    FRAMED_CUBE(true, false, false, false, true, true, CtmPredicate.TRUE, SideSkipPredicate.CTM, VoxelShapes.func_197868_b()),
    FRAMED_SLOPE(true, true, false, true, true, true, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSkipPredicate(), FramedSlopeBlock::generateShapes),
    FRAMED_CORNER_SLOPE(true, true, false, true, true, true, FramedCornerSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new CornerSkipPredicate(), FramedCornerSlopeBlock::generateCornerShapes),
    FRAMED_INNER_CORNER_SLOPE(true, true, false, true, true, true, FramedCornerSlopeBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new InnerCornerSkipPredicate(), FramedCornerSlopeBlock::generateInnerCornerShapes),
    FRAMED_PRISM_CORNER(true, true, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generatePrismShapes),
    FRAMED_INNER_PRISM_CORNER(true, true, false, true, true, true, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generateInnerPrismShapes),
    FRAMED_THREEWAY_CORNER(true, true, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateThreewayShapes),
    FRAMED_INNER_THREEWAY_CORNER(true, true, false, true, true, true, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateInnerThreewayShapes),
    FRAMED_SLAB(true, false, false, true, true, true, FramedSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new SlabSkipPredicate(), FramedSlabBlock::generateShapes),
    FRAMED_SLAB_EDGE(false, false, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new SlabEdgeSkipPredicate(), FramedSlabEdgeBlock::generateShapes),
    FRAMED_SLAB_CORNER(false, false, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new SlabCornerSkipPredicate(), FramedSlabCornerBlock::generateShapes),
    FRAMED_PANEL(true, false, false, true, true, true, FramedPanelBlock.CTM_PREDICATE, (SideSkipPredicate)new PanelSkipPredicate(), FramedPanelBlock::generateShapes),
    FRAMED_CORNER_PILLAR(false, false, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new CornerPillarSkipPredicate(), FramedCornerPillarBlock::generateShapes),
    FRAMED_STAIRS(true, false, false, true, true, true, FramedStairsBlock.CTM_PREDICATE, new StairsSkipPredicate()),
    FRAMED_WALL(false, false, false, true, true, false, CtmPredicate.FALSE, new WallSkipPredicate()),
    FRAMED_FENCE(false, false, false, true, true, false, CtmPredicate.FALSE, FramedFenceBlock.SKIP_PREDICATE),
    FRAMED_GATE(false, false, false, true, true, false, CtmPredicate.FALSE, FramedGateBlock.SKIP_PREDICATE),
    FRAMED_DOOR(true, false, false, false, true, false, FramedDoorBlock.CTM_PREDICATE, new DoorSkipPredicate()),
    FRAMED_TRAPDOOR(true, false, false, true, true, false, FramedTrapDoorBlock.CTM_PREDICATE, SideSkipPredicate.CTM),
    FRAMED_PRESSURE_PLATE(false, false, false, false, true, false),
    FRAMED_LADDER(false, false, false, true, true, false),
    FRAMED_BUTTON(false, false, false, false, true, false),
    FRAMED_LEVER(false, false, false, false, true, false),
    FRAMED_SIGN(false, false, true, false, true, false),
    FRAMED_WALL_SIGN(false, false, true, false, false, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedWallSignBlock::generateShapes),
    FRAMED_DOUBLE_SLAB(true, false, true, false, true, true, CtmPredicate.Y_AXIS, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_PANEL(true, false, true, false, true, true, FramedDoublePanelBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_SLOPE(true, false, true, false, true, true, FramedDoubleSlopeBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_CORNER(true, false, true, false, true, true, FramedDoubleCornerBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_PRISM_CORNER(true, false, true, false, true, true, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_DOUBLE_THREEWAY_CORNER(true, false, true, false, true, true, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, VoxelShapes.func_197868_b()),
    FRAMED_TORCH(false, false, false, false, true, false),
    FRAMED_WALL_TORCH(false, false, false, false, false, false),
    FRAMED_SOUL_TORCH(false, false, false, false, true, false),
    FRAMED_SOUL_WALL_TORCH(false, false, false, false, false, false),
    FRAMED_FLOOR_BOARD(true, false, false, true, true, true, FramedFloorBlock.CTM_PREDICATE, FramedFloorBlock.SKIP_PREDICATE, VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0)),
    FRAMED_LATTICE_BLOCK(false, false, false, true, true, true, CtmPredicate.FALSE, FramedLatticeBlock.SKIP_PREDICATE, FramedLatticeBlock::generateShapes),
    FRAMED_VERTICAL_STAIRS(true, false, false, true, true, true, FramedVerticalStairsBlock.CTM_PREDICATE, (SideSkipPredicate)new VerticalStairsSkipPredicate(), FramedVerticalStairsBlock::generateShapes),
    FRAMED_CHEST(false, false, true, true, true, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375)),
    FRAMED_BARS(false, false, false, true, true, true, CtmPredicate.FALSE, SideSkipPredicate.FALSE),
    FRAMED_PANE(false, false, false, true, true, true, CtmPredicate.FALSE, new PaneSkipPredicate()),
    FRAMED_RAIL_SLOPE(true, true, false, true, true, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSkipPredicate(), FramedSlopeBlock::generateShapes),
    FRAMED_FLOWER_POT(false, false, true, false, true, false, CtmPredicate.FALSE, SideSkipPredicate.FALSE, VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875)),
    FRAMED_PILLAR(false, false, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new PillarSkipPredicate(), FramedPillarBlock::generatePillarShapes),
    FRAMED_HALF_PILLAR(false, false, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new HalfPillarSkipPredicate(), FramedHalfPillarBlock::generateShapes),
    FRAMED_POST(false, false, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new PostSkipPredicate(), FramedPillarBlock::generatePostShapes),
    FRAMED_COLLAPSIBLE_BLOCK(false, true, true, true, true, true, FramedCollapsibleBlock.CTM_PREDICATE, new CollapsibleBlockSkipPredicate()),
    FRAMED_HALF_STAIRS(false, false, false, true, true, true, CtmPredicate.FALSE, (SideSkipPredicate)new HalfStairsSkipPredicate(), FramedHalfStairsBlock::generateShapes),
    FRAMED_BOUNCY_CUBE(true, false, false, false, true, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, VoxelShapes.func_197868_b()),
    FRAMED_SECRET_STORAGE(true, false, true, false, true, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, VoxelShapes.func_197868_b()),
    FRAMED_REDSTONE_BLOCK(true, false, false, false, true, true, CtmPredicate.TRUE, SideSkipPredicate.CTM, VoxelShapes.func_197868_b()),
    FRAMED_PRISM(true, true, false, true, true, true, FramedPrismBlock.CTM_PREDICATE, FramedPrismBlock.SKIP_PREDICATE, FramedPrismBlock::generateShapes),
    FRAMED_SLOPED_PRISM(true, true, false, true, true, true, FramedSlopedPrismBlock.CTM_PREDICATE, FramedSlopedPrismBlock.SKIP_PREDICATE, FramedSlopedPrismBlock::generateShapes),
    FRAMED_SLOPE_SLAB(true, true, false, true, true, true, FramedSlopeSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSlabSkipPredicate(), FramedSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_SLOPE_SLAB(true, true, true, true, true, true, FramedElevatedSlopeSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new ElevatedSlopeSlabSkipPredicate(), FramedElevatedSlopeSlabBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_SLAB(true, false, true, true, true, true, FramedDoubleSlopeSlabBlock.CTM_PREDICATE, SideSkipPredicate.FALSE),
    FRAMED_INV_DOUBLE_SLOPE_SLAB(true, true, true, true, true, true, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedInverseDoubleSlopeSlabBlock::generateShapes),
    FRAMED_VERTICAL_HALF_STAIRS(false, false, false, true, true, false, CtmPredicate.FALSE, (SideSkipPredicate)new VerticalHalfStairsSkipPredicate(), FramedVerticalHalfStairsBlock::generateShapes),
    FRAMED_SLOPE_PANEL(true, true, false, true, true, true, FramedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopePanelSkipPredicate(), FramedSlopePanelBlock::generateShapes),
    FRAMED_EXTENDED_SLOPE_PANEL(true, true, true, true, true, true, FramedExtendedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new ExtendedSlopePanelSkipPredicate(), FramedExtendedSlopePanelBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_PANEL(true, false, true, true, true, true, FramedDoubleSlopePanelBlock.CTM_PREDICATE, SideSkipPredicate.FALSE, FramedDoubleSlopePanelBlock::generateShapes),
    FRAMED_INV_DOUBLE_SLOPE_PANEL(true, true, true, true, true, true, CtmPredicate.FALSE, SideSkipPredicate.FALSE, FramedInverseDoubleSlopePanelBlock::generateShapes);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean canOcclude;
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final boolean allowIntangible;
    private final CtmPredicate ctmPredicate;
    private final SideSkipPredicate skipPredicate;
    private final VoxelShapeGenerator shapeGen;

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, CtmPredicate.FALSE, SideSkipPredicate.FALSE, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, ctmPredicate, skipPredicate, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, ctmPredicate, skipPredicate, VoxelShapeGenerator.singleShape(shape));
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShapeGenerator shapeGen) {
        this.canOcclude = canOcclude;
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.allowIntangible = allowIntangible;
        this.ctmPredicate = ctmPredicate;
        this.skipPredicate = skipPredicate;
        this.shapeGen = shapeGen;
    }

    public boolean canOccludeWithSolidCamo() {
        return this.canOcclude;
    }

    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    public CtmPredicate getCtmPredicate() {
        return this.ctmPredicate;
    }

    public SideSkipPredicate getSideSkipPredicate() {
        return this.skipPredicate;
    }

    public ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return this.shapeGen.generate(states);
    }

    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    public boolean hasBlockItem() {
        return this.blockItem;
    }

    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    public boolean allowMakingIntangible() {
        return this.allowIntangible;
    }

    public String getName() {
        return this.name;
    }
}

