/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.tileentity.FramedInverseDoubleSlopePanelTileEntity;
import xfacthd.framedblocks.common.util.Utils;

public class FramedInverseDoubleSlopePanelBlock
extends AbstractFramedDoubleBlock {
    public FramedInverseDoubleSlopePanelBlock() {
        super(BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.ROTATION, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f();
        Direction side = context.func_196000_l();
        Rotation rotation = side == facing.func_176734_d() ? Rotation.fromWallCross(context.func_221532_j(), side) : Rotation.fromDirection(facing, side);
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing)).func_206870_a(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return FramedInverseDoubleSlopePanelBlock.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedInverseDoubleSlopePanelTileEntity();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            Rotation rotation = (Rotation)((Object)state.func_177229_b(PropertyHolder.ROTATION));
            VoxelShape shapeOne = FramedSlopePanelBlock.SHAPES.get((Object)(rotation.isVertical() ? rotation.getOpposite() : rotation));
            VoxelShape shape = VoxelShapes.func_197872_a((VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.SOUTH, shapeOne.func_197751_a(0.0, 0.0, 0.5)), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rotation).func_197751_a(0.0, 0.0, 0.5));
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

