/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedWallTorchModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_torch");
    private static final Vector3f ROTATION_ORIGIN = new Vector3f(0.0f, 0.21875f, 0.5f);
    private final Direction dir;

    public FramedWallTorchModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return RenderTypeLookup.canRenderInLayer((BlockState)Blocks.field_150478_aa.func_176223_P(), (RenderType)layer);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData extraData, RenderType layer) {
        List quads = this.baseModel.getQuads(state, null, rand, extraData);
        for (BakedQuad quad : quads) {
            if (quad.func_187508_a().func_195668_m().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.4375f, 0.4375f, 0.5625f, 0.5625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.func_178210_d() == Direction.UP ? 0.71875f : 0.78125f);
                BakedQuadTransformer.offsetQuadInDir(topBotQuad, Direction.WEST, 0.5f);
                quadMap.get(null).add(topBotQuad);
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.4375f, 0.0f, 0.5625f, 0.5f)) {
                if (quad.func_178210_d() == Direction.EAST) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.0625f);
                } else if (quad.func_178210_d() == Direction.WEST) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 1.0625f);
                } else {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    BakedQuadTransformer.offsetQuadInDir(sideQuad, Direction.WEST, 0.5f);
                }
                BakedQuadTransformer.offsetQuadInDir(sideQuad, Direction.UP, 0.21875f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }

    @Override
    protected void postProcessQuads(Map<Direction, List<BakedQuad>> quadMap) {
        float yAngle = 270.0f - this.dir.func_185119_l();
        quadMap.get(null).forEach(q -> {
            BakedQuadTransformer.rotateQuadAroundAxis(q, Direction.Axis.Z, ROTATION_ORIGIN, -22.5f, false);
            BakedQuadTransformer.rotateQuadAroundAxisCentered(q, Direction.Axis.Y, yAngle, false);
        });
    }

    @Override
    public boolean func_177555_b() {
        return false;
    }
}

