/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;

public class FramedSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final SlopeType type;

    public FramedSlopeModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.type = (SlopeType)((Object)state.func_177229_b(PropertyHolder.SLOPE_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad triQuad;
        if (this.type == SlopeType.HORIZONTAL) {
            BakedQuad triQuad2;
            if (quad.func_178210_d() == this.dir.func_176734_d()) {
                BakedQuad slopeQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.createSideSlopeQuad(slopeQuad, true);
                quadMap.get(null).add(slopeQuad);
            } else if ((quad.func_178210_d() == Direction.UP || quad.func_178210_d() == Direction.DOWN) && BakedQuadTransformer.createTopBottomTriangleQuad(triQuad2 = ModelUtils.duplicateQuad(quad), this.dir)) {
                quadMap.get(quad.func_178210_d()).add(triQuad2);
            }
        } else if (quad.func_178210_d() == this.dir.func_176734_d()) {
            BakedQuad slopeQuad = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.createTopBottomSlopeQuad(slopeQuad, this.type == SlopeType.BOTTOM);
            quadMap.get(null).add(slopeQuad);
        } else if ((quad.func_178210_d() == this.dir.func_176746_e() || quad.func_178210_d() == this.dir.func_176735_f()) && BakedQuadTransformer.createSideTriangleQuad(triQuad = ModelUtils.duplicateQuad(quad), quad.func_178210_d() == this.dir.func_176746_e(), this.type == SlopeType.TOP)) {
            quadMap.get(quad.func_178210_d()).add(triQuad);
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedSlope.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

