/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedSlopeSlabModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedElevatedSlopeSlabModel
extends FramedBlockModel {
    private final Direction facing;
    private final boolean top;

    public FramedElevatedSlopeSlabModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad triangle;
        Direction face = quad.func_178210_d();
        if (face == this.facing.func_176734_d()) {
            BakedQuad slope = FramedSlopeSlabModel.createSlope(quad, this.facing, this.top);
            BakedQuadTransformer.offsetQuadInDir(slope, this.top ? Direction.DOWN : Direction.UP, 0.5f);
            quadMap.get(null).add(slope);
            BakedQuad slab = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slab, this.top, 0.5f)) {
                quadMap.get(face).add(slab);
            }
        } else if ((face == this.facing.func_176746_e() || face == this.facing.func_176735_f()) && BakedQuadTransformer.createSideTriangleQuad(triangle = ModelUtils.duplicateQuad(quad), face == this.facing.func_176746_e(), this.top, 0.5f, 0.5f)) {
            quadMap.get(face).add(triangle);
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedElevatedSlopeSlab.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

