/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedDoorModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean hingeRight;
    private final boolean open;

    public FramedDoorModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        this.hingeRight = state.func_177229_b((Property)BlockStateProperties.field_208142_aq) == DoorHingeSide.RIGHT;
        this.open = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208193_t);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        boolean facePositive;
        Direction faceDir = this.dir;
        if (this.open) {
            faceDir = this.hingeRight ? faceDir.func_176735_f() : faceDir.func_176746_e();
        }
        boolean bl = facePositive = faceDir.func_176743_c() == Direction.AxisDirection.POSITIVE;
        if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, faceDir, 0.1875f)) {
                quadMap.get(quad.func_178210_d()).add(topBotQuad);
            }
        } else if (quad.func_178210_d() == faceDir) {
            BakedQuad faceQuad = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.setQuadPosInFacingDir(faceQuad, 0.1875f);
            quadMap.get(null).add(faceQuad);
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad, !facePositive, 0.1875f)) {
                quadMap.get(quad.func_178210_d()).add(sideQuad);
            }
        }
    }
}

