/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.model.FramedBarsModel;
import xfacthd.framedblocks.client.model.FramedButtonModel;
import xfacthd.framedblocks.client.model.FramedChestModel;
import xfacthd.framedblocks.client.model.FramedCollapsibleBlockModel;
import xfacthd.framedblocks.client.model.FramedCornerPillarModel;
import xfacthd.framedblocks.client.model.FramedCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedCubeModel;
import xfacthd.framedblocks.client.model.FramedDoorModel;
import xfacthd.framedblocks.client.model.FramedDoubleCornerModel;
import xfacthd.framedblocks.client.model.FramedDoublePanelModel;
import xfacthd.framedblocks.client.model.FramedDoublePrismCornerModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlabModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlopeModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlopePanelModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlopeSlabModel;
import xfacthd.framedblocks.client.model.FramedDoubleThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedElevatedSlopeSlabModel;
import xfacthd.framedblocks.client.model.FramedExtendedSlopePanelModel;
import xfacthd.framedblocks.client.model.FramedFenceGateModel;
import xfacthd.framedblocks.client.model.FramedFenceModel;
import xfacthd.framedblocks.client.model.FramedFloorModel;
import xfacthd.framedblocks.client.model.FramedFlowerPotModel;
import xfacthd.framedblocks.client.model.FramedHalfPillarModel;
import xfacthd.framedblocks.client.model.FramedHalfStairsModel;
import xfacthd.framedblocks.client.model.FramedInnerCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedInnerPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedInnerThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedInverseDoubleSlopePanelModel;
import xfacthd.framedblocks.client.model.FramedInverseDoubleSlopeSlabModel;
import xfacthd.framedblocks.client.model.FramedLadderModel;
import xfacthd.framedblocks.client.model.FramedLatticeModel;
import xfacthd.framedblocks.client.model.FramedLeverModel;
import xfacthd.framedblocks.client.model.FramedMarkedCubeModel;
import xfacthd.framedblocks.client.model.FramedPaneModel;
import xfacthd.framedblocks.client.model.FramedPanelModel;
import xfacthd.framedblocks.client.model.FramedPillarModel;
import xfacthd.framedblocks.client.model.FramedPressurePlateModel;
import xfacthd.framedblocks.client.model.FramedPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedPrismModel;
import xfacthd.framedblocks.client.model.FramedRailSlopeModel;
import xfacthd.framedblocks.client.model.FramedSignModel;
import xfacthd.framedblocks.client.model.FramedSlabCornerModel;
import xfacthd.framedblocks.client.model.FramedSlabEdgeModel;
import xfacthd.framedblocks.client.model.FramedSlabModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.model.FramedSlopePanelModel;
import xfacthd.framedblocks.client.model.FramedSlopeSlabModel;
import xfacthd.framedblocks.client.model.FramedSlopedPrismModel;
import xfacthd.framedblocks.client.model.FramedSoulTorchModel;
import xfacthd.framedblocks.client.model.FramedSoulWallTorchModel;
import xfacthd.framedblocks.client.model.FramedStairsModel;
import xfacthd.framedblocks.client.model.FramedThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedTorchModel;
import xfacthd.framedblocks.client.model.FramedTrapDoorModel;
import xfacthd.framedblocks.client.model.FramedVerticalHalfStairsModel;
import xfacthd.framedblocks.client.model.FramedVerticalStairsModel;
import xfacthd.framedblocks.client.model.FramedWallModel;
import xfacthd.framedblocks.client.model.FramedWallSignModel;
import xfacthd.framedblocks.client.model.FramedWallTorchModel;
import xfacthd.framedblocks.client.render.BlockOutlineRenderer;
import xfacthd.framedblocks.client.render.FramedChestRenderer;
import xfacthd.framedblocks.client.render.FramedSignRenderer;
import xfacthd.framedblocks.client.render.outline.CollapsibleBlockOutlineRenderer;
import xfacthd.framedblocks.client.render.outline.ExtendedSlopePanelOutlineRenderer;
import xfacthd.framedblocks.client.render.outline.InverseDoubleSlopePanelOutlineRenderer;
import xfacthd.framedblocks.client.render.outline.PrismOutlineRenderer;
import xfacthd.framedblocks.client.render.outline.RailSlopeOutlineRenderer;
import xfacthd.framedblocks.client.render.outline.SlopePanelOutlineRenderer;
import xfacthd.framedblocks.client.render.outline.SlopedPrismOutlineRenderer;
import xfacthd.framedblocks.client.screen.FramedSignScreen;
import xfacthd.framedblocks.client.screen.FramedStorageScreen;
import xfacthd.framedblocks.client.util.BlueprintPropertyOverride;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedDoubleTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedFlowerPotTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedSignTileEntity;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FBClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, type -> type == RenderType.func_228639_c_() || type == RenderType.func_228643_e_() || type == RenderType.func_228641_d_() || type == RenderType.func_228645_f_()));
        RenderTypeLookup.setRenderLayer((Block)((Block)FBContent.blockFramedGhostBlock.get()), (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)FBContent.tileTypeFramedSign.get()), FramedSignRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)FBContent.tileTypeFramedChest.get()), FramedChestRenderer::new);
        event.enqueueWork(() -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)FBContent.containerTypeFramedChest.get()), FramedStorageScreen::new);
            BlueprintPropertyOverride.register();
        });
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_SLOPE, BlockOutlineRenderer::drawSlopeBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_CORNER_SLOPE, BlockOutlineRenderer::drawCornerSlopeBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INNER_CORNER_SLOPE, BlockOutlineRenderer::drawInnerCornerSlopeBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_PRISM_CORNER, BlockOutlineRenderer::drawPrismCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INNER_PRISM_CORNER, BlockOutlineRenderer::drawInnerPrismCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_THREEWAY_CORNER, BlockOutlineRenderer::drawThreewayCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockOutlineRenderer::drawInnerThreewayCornerBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_RAIL_SLOPE, new RailSlopeOutlineRenderer());
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_COLLAPSIBLE_BLOCK, new CollapsibleBlockOutlineRenderer());
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_PRISM, new PrismOutlineRenderer());
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_SLOPED_PRISM, new SlopedPrismOutlineRenderer());
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_SLOPE_SLAB, BlockOutlineRenderer::drawSlopeSlabBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_ELEVATED_SLOPE_SLAB, BlockOutlineRenderer::drawElevatedSlopeSlabBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB, BlockOutlineRenderer::drawInverseDoubleSlopeSlabBox);
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_SLOPE_PANEL, new SlopePanelOutlineRenderer());
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_EXTENDED_SLOPE_PANEL, new ExtendedSlopePanelOutlineRenderer());
        BlockOutlineRenderer.registerOutlineRender(BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL, new InverseDoubleSlopePanelOutlineRenderer());
    }

    @SubscribeEvent
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        Block[] blocks = (Block[])FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).toArray(Block[]::new);
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            if (world != null && pos != null) {
                BlockState camoState;
                TileEntity te = world.func_175625_s(pos);
                if (tintIndex < -1) {
                    BlockState plantState;
                    tintIndex = ModelUtils.decodeSecondaryTintIndex(tintIndex);
                    if (te instanceof FramedDoubleTileEntity) {
                        BlockState camoState2 = ((FramedDoubleTileEntity)te).getCamoStateTwo();
                        if (!camoState2.func_196958_f()) {
                            return event.getBlockColors().func_228054_a_(camoState2, world, pos, tintIndex);
                        }
                    } else if (te instanceof FramedFlowerPotTileEntity && !(plantState = ((FramedFlowerPotTileEntity)te).getFlowerBlock().func_176223_P()).func_196958_f()) {
                        return event.getBlockColors().func_228054_a_(plantState, world, pos, tintIndex);
                    }
                } else if (te instanceof FramedTileEntity && !(camoState = ((FramedTileEntity)te).getCamoState()).func_196958_f()) {
                    return event.getBlockColors().func_228054_a_(camoState, world, pos, tintIndex);
                }
            }
            return -1;
        }, blocks);
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)FramedMarkedCubeModel.SLIME_FRAME_LOCATION);
        ModelLoader.addSpecialModel((ResourceLocation)FramedMarkedCubeModel.REDSTONE_FRAME_LOCATION);
    }

    @SubscribeEvent
    public static void onModelsLoaded(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        FramedChestRenderer.onModelsLoaded(registry);
        List<BooleanProperty> ignoreWaterlogged = Collections.singletonList(BlockStateProperties.field_208198_y);
        List<BooleanProperty> ignoreSolid = Collections.singletonList(PropertyHolder.SOLID);
        List<Property<?>> ignoreDefault = Arrays.asList(BlockStateProperties.field_208198_y, PropertyHolder.SOLID);
        FBClient.replaceModels(FBContent.blockFramedCube, registry, FramedCubeModel::new, ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedSlope, registry, FramedSlopeModel::new, FramedSlopeModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedCornerSlope, registry, FramedCornerSlopeModel::new, FramedCornerSlopeModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedInnerCornerSlope, registry, FramedInnerCornerSlopeModel::new, FramedInnerCornerSlopeModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedPrismCorner, registry, FramedPrismCornerModel::new, FramedPrismCornerModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedInnerPrismCorner, registry, FramedInnerPrismCornerModel::new, FramedInnerPrismCornerModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedThreewayCorner, registry, FramedThreewayCornerModel::new, FramedThreewayCornerModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedInnerThreewayCorner, registry, FramedInnerThreewayCornerModel::new, FramedInnerThreewayCornerModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedSlab, registry, FramedSlabModel::new, ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedSlabEdge, registry, FramedSlabEdgeModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedSlabCorner, registry, FramedSlabCornerModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedPanel, registry, FramedPanelModel::new, ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedCornerPillar, registry, FramedCornerPillarModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedStairs, registry, FramedStairsModel::new, ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedWall, registry, FramedWallModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedFence, registry, FramedFenceModel::createFenceModel, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedGate, registry, FramedFenceGateModel::new, Collections.singletonList(BlockStateProperties.field_208194_u));
        FBClient.replaceModels(FBContent.blockFramedDoor, registry, FramedDoorModel::new, ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedTrapDoor, registry, FramedTrapDoorModel::new, ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedPressurePlate, registry, FramedPressurePlateModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedLadder, registry, FramedLadderModel::new, FramedLadderModel.itemSource(), ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedButton, registry, FramedButtonModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedLever, registry, FramedLeverModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedSign, registry, FramedSignModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedWallSign, registry, FramedWallSignModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlab, registry, FramedDoubleSlabModel::new, ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedDoublePanel, registry, FramedDoublePanelModel::new, ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlope, registry, FramedDoubleSlopeModel::new, ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedDoubleCorner, registry, FramedDoubleCornerModel::new, FramedDoubleCornerModel.itemSource(), ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedDoublePrismCorner, registry, FramedDoublePrismCornerModel::new, FramedDoublePrismCornerModel.itemSource(), ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedDoubleThreewayCorner, registry, FramedDoubleThreewayCornerModel::new, FramedDoubleThreewayCornerModel.itemSource(), ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedTorch, registry, FramedTorchModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedWallTorch, registry, FramedWallTorchModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedSoulTorch, registry, FramedSoulTorchModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedSoulWallTorch, registry, FramedSoulWallTorchModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedFloor, registry, FramedFloorModel::new, ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedLattice, registry, FramedLatticeModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedVerticalStairs, registry, FramedVerticalStairsModel::new, ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedChest, registry, FramedChestModel::new, FramedChestModel.itemSource(), ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedBars, registry, FramedBarsModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedPane, registry, FramedPaneModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedRailSlope, registry, FramedRailSlopeModel::new, FramedRailSlopeModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedFlowerPot, registry, FramedFlowerPotModel::new, null);
        FBClient.replaceModels(FBContent.blockFramedPillar, registry, FramedPillarModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedHalfPillar, registry, FramedHalfPillarModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedPost, registry, FramedPillarModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedCollapsibleBlock, registry, FramedCollapsibleBlockModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedHalfStairs, registry, FramedHalfStairsModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedBouncyCube, registry, (state, baseModel) -> FramedMarkedCubeModel.slime(state, baseModel, registry), ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedSecretStorage, registry, FramedCubeModel::new, ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedRedstoneBlock, registry, (state, baseModel) -> FramedMarkedCubeModel.redstone(state, baseModel, registry), ignoreSolid);
        FBClient.replaceModels(FBContent.blockFramedPrism, registry, FramedPrismModel::new, FramedPrismModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedSlopedPrism, registry, FramedSlopedPrismModel::new, FramedSlopedPrismModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedSlopeSlab, registry, FramedSlopeSlabModel::new, FramedSlopeSlabModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedElevatedSlopeSlab, registry, FramedElevatedSlopeSlabModel::new, FramedElevatedSlopeSlabModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlopeSlab, registry, FramedDoubleSlopeSlabModel::new, FramedDoubleSlopeSlabModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedInverseDoubleSlopeSlab, registry, FramedInverseDoubleSlopeSlabModel::new, FramedInverseDoubleSlopeSlabModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedVerticalHalfStairs, registry, FramedVerticalHalfStairsModel::new, ignoreWaterlogged);
        FBClient.replaceModels(FBContent.blockFramedSlopePanel, registry, FramedSlopePanelModel::new, FramedSlopePanelModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedExtendedSlopePanel, registry, FramedExtendedSlopePanelModel::new, FramedExtendedSlopePanelModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlopePanel, registry, FramedDoubleSlopePanelModel::new, FramedDoubleSlopePanelModel.itemSource(), ignoreDefault);
        FBClient.replaceModels(FBContent.blockFramedInverseDoubleSlopePanel, registry, FramedInverseDoubleSlopePanelModel::new, FramedInverseDoubleSlopePanelModel.itemSource(), ignoreDefault);
    }

    private static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, IBakedModel> models, BiFunction<BlockState, IBakedModel, IBakedModel> blockModelGen, @Nullable List<Property<?>> ignoredProps) {
        FBClient.replaceModels(block, models, blockModelGen, null, ignoredProps);
    }

    private static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, IBakedModel> models, BiFunction<BlockState, IBakedModel, IBakedModel> blockModelGen, @Nullable BlockState itemModelSource, @Nullable List<Property<?>> ignoredProps) {
        HashMap<BlockState, IBakedModel> visitedStates = new HashMap<BlockState, IBakedModel>();
        for (BlockState state : ((Block)block.get()).func_176194_O().func_177619_a()) {
            ModelResourceLocation location = BlockModelShapes.func_209554_c((BlockState)state);
            IBakedModel baseModel = models.get(location);
            IBakedModel replacement = visitedStates.computeIfAbsent(FBClient.ignoreProps(state, ignoredProps), key -> (IBakedModel)blockModelGen.apply((BlockState)key, baseModel));
            models.put((ResourceLocation)location, replacement);
        }
        if (itemModelSource != null) {
            ModelResourceLocation location = new ModelResourceLocation(((Block)block.get()).getRegistryName(), "inventory");
            IBakedModel replacement = models.get(BlockModelShapes.func_209554_c((BlockState)itemModelSource));
            models.put((ResourceLocation)location, replacement);
        }
    }

    private static BlockState ignoreProps(BlockState state, @Nullable List<Property<?>> ignoredProps) {
        if (ignoredProps == null || ignoredProps.isEmpty()) {
            return state;
        }
        BlockState defaultState = state.func_177230_c().func_176223_P();
        for (Property<?> prop : ignoredProps) {
            if (!state.func_235901_b_(prop)) {
                FramedBlocks.LOGGER.warn("Found invalid ignored property {} for block {}!", prop, (Object)state.func_177230_c());
                continue;
            }
            state = (BlockState)state.func_206870_a(prop, defaultState.func_177229_b(prop));
        }
        return state;
    }

    public static void openSignScreen(BlockPos pos) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        if (te instanceof FramedSignTileEntity) {
            Minecraft.func_71410_x().func_147108_a((Screen)new FramedSignScreen((FramedSignTileEntity)te));
        }
    }
}

