/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.init.FishRegistry;
import com.teammetallurgy.aquaculture.loot.BiomeTagPredicate;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import com.teammetallurgy.aquaculture.misc.BiomeDictionaryHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.ForgeRegistries;

public class FishReadFromJson {
    public static HashMap<EntityType<?>, List<ResourceLocation>> FISH_BIOME_MAP = new HashMap();
    public static HashMap<EntityType<?>, Integer> FISH_WEIGHT_MAP = new HashMap();
    private static final Gson GSON_INSTANCE = new GsonBuilder().setPrettyPrinting().create();
    public static boolean hasRunFirstTime;

    public static void read() {
        try {
            InputStreamReader fileReader;
            String filePath = "aquaculture/loot_tables/" + AquaLootTables.FISH.func_110623_a() + ".json";
            if (Aquaculture.IS_DEV) {
                ModFile modFile = ModList.get().getModFileById("aquaculture").getFile();
                Path root = modFile.getLocator().findPath((IModFile)modFile, new String[]{ResourcePackType.SERVER_DATA.func_198956_a()}).toAbsolutePath();
                fileReader = new FileReader(root.resolve(root.getFileSystem().getPath(filePath, new String[0])).toFile());
            } else {
                fileReader = new InputStreamReader(Aquaculture.instance.getClass().getResourceAsStream("/data/" + filePath));
            }
            BufferedReader reader = new BufferedReader(fileReader);
            JsonElement json = (JsonElement)GSON_INSTANCE.fromJson((Reader)reader, JsonElement.class);
            if (json != null && !json.isJsonNull()) {
                JsonObject jsonObject = json.getAsJsonObject();
                JsonArray pools = jsonObject.getAsJsonArray("pools");
                JsonObject poolsObject = pools.get(0).getAsJsonObject();
                JsonArray entries = poolsObject.getAsJsonArray("entries");
                for (JsonElement entry : entries) {
                    JsonArray conditions = entry.getAsJsonObject().getAsJsonArray("conditions");
                    EntityType<?> fish = FishReadFromJson.getEntityFromString(entry.getAsJsonObject().get("name").toString());
                    for (JsonElement conditionElement : conditions) {
                        JsonObject condition = conditionElement.getAsJsonObject();
                        if (condition.get("condition").getAsString().equals("aquaculture:biome_tag_check")) {
                            FISH_BIOME_MAP.put(fish, FishReadFromJson.getSpawnableBiomes(condition.get("predicate")));
                            continue;
                        }
                        if (!condition.get("condition").getAsString().equals("minecraft:alternative")) continue;
                        for (JsonElement term : condition.getAsJsonObject().getAsJsonArray("terms")) {
                            List<ResourceLocation> spawnableBiomes = FishReadFromJson.getSpawnableBiomes(term.getAsJsonObject().get("predicate"));
                            if (!FISH_BIOME_MAP.containsKey(fish)) {
                                FISH_BIOME_MAP.put(fish, spawnableBiomes);
                                continue;
                            }
                            spawnableBiomes.forEach(biome -> FISH_BIOME_MAP.get(fish).add((ResourceLocation)biome));
                        }
                    }
                    FISH_WEIGHT_MAP.put(fish, entry.getAsJsonObject().get("weight").getAsInt());
                }
                FISH_BIOME_MAP.keySet().retainAll(FishRegistry.fishEntities);
                FISH_WEIGHT_MAP.keySet().retainAll(FishRegistry.fishEntities);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static EntityType<?> getEntityFromString(String name) {
        name = name.replace("\"", "");
        return (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(name));
    }

    private static List<ResourceLocation> getSpawnableBiomes(JsonElement predicate) {
        int entry;
        ArrayList biomes = Lists.newArrayList();
        ArrayList includeList = Lists.newArrayList();
        ArrayList excludeList = Lists.newArrayList();
        boolean and = false;
        if (predicate.getAsJsonObject().has("include")) {
            JsonArray include = predicate.getAsJsonObject().get("include").getAsJsonArray();
            for (entry = 0; entry < include.size(); ++entry) {
                includeList.add(BiomeDictionaryHelper.getType(include.get(entry).getAsString().toLowerCase(Locale.ROOT)));
            }
        }
        if (predicate.getAsJsonObject().has("exclude")) {
            JsonArray exclude = predicate.getAsJsonObject().get("exclude").getAsJsonArray();
            for (entry = 0; entry < exclude.size(); ++entry) {
                excludeList.add(BiomeDictionaryHelper.getType(exclude.get(entry).getAsString().toLowerCase(Locale.ROOT)));
            }
        }
        if (predicate.getAsJsonObject().has("and")) {
            and = predicate.getAsJsonObject().get("and").getAsBoolean();
        }
        biomes.addAll(BiomeTagPredicate.getValidBiomes(includeList, excludeList, and));
        return biomes;
    }

    public static void addFishSpawns(BiomeLoadingEvent event) {
        if (((Boolean)AquaConfig.BASIC_OPTIONS.enableFishSpawning.get()).booleanValue() && !FISH_BIOME_MAP.isEmpty()) {
            for (EntityType<?> fish : FISH_BIOME_MAP.keySet()) {
                ResourceLocation name;
                if (((Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get()).booleanValue() && !hasRunFirstTime) {
                    ArrayList<String> strings = new ArrayList<String>();
                    for (ResourceLocation biome : FISH_BIOME_MAP.get(fish)) {
                        if (biome == null) continue;
                        strings.add(biome.func_110623_a());
                    }
                    Aquaculture.LOG.info(fish.getRegistryName() + " Biomes: " + strings);
                }
                int weight = FISH_WEIGHT_MAP.get(fish) / 3;
                int maxGroupSize = MathHelper.func_76125_a((int)(FISH_WEIGHT_MAP.get(fish) / 10), (int)1, (int)8);
                if (weight < 1) {
                    weight = 1;
                }
                if (((Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get()).booleanValue() && !hasRunFirstTime) {
                    Aquaculture.LOG.info(fish.getRegistryName() + " spawn debug = loottable weight: " + FISH_WEIGHT_MAP.get(fish) + " | weight : " + weight + " | maxGroupSize: " + maxGroupSize);
                }
                if ((name = event.getName()) == null) continue;
                for (ResourceLocation biome : FISH_BIOME_MAP.get(fish)) {
                    if (!name.equals((Object)biome)) continue;
                    event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT).add(new MobSpawnInfo.Spawners(fish, weight, 1, maxGroupSize));
                }
            }
            hasRunFirstTime = true;
        }
    }
}

