/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class IItemHandlerTEBase
extends TileEntity
implements INameable {
    private ITextComponent customName;
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(this::createItemHandler);

    public IItemHandlerTEBase(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    @Nonnull
    protected abstract IItemHandler createItemHandler();

    public void func_230337_a_(@Nonnull BlockState state, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(stack -> ((INBTSerializable)stack).deserializeNBT((INBT)invTag));
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("CustomName"));
        }
        super.func_230337_a_(state, tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tag) {
        this.handler.ifPresent(stack -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)stack).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        if (this.customName != null) {
            tag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return super.func_189515_b(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }
}

